---
generated_at: 2026-01-23 21:52:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-アセットマネージャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_assetmanager.asp` - アセットマネージャー呼び出し
- E-02: `asp/assetmanager/assetmanagerIF.asp` - メインインターフェース
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.125-128のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アセットマネージャーはbs_assetmanager.aspで呼び出される | E-01 | ○ |
| C-02 | セカンドアドミンのbFiles権限チェックが行われる | E-01 (4行目) | ○ |
| C-03 | assetmanagerIF.aspがiframeで読み込まれる | E-01 (4行目) | ○ |
| C-04 | 最大4つのベースフォルダを設定可能 | E-02 (26-30行目) | ○ |
| C-05 | recursive関数でフォルダ構造を再帰取得 | E-02 (80-99行目) | ○ |
| C-06 | writeFileSelections関数でファイル一覧を生成 | E-02 (110-264行目) | ○ |
| C-07 | ffilter=imageでgif/jpg/jpeg/pngをフィルタリング | E-02 (135行目) | ○ |
| C-08 | ffilter=mediaでメディアファイルをフィルタリング | E-02 (131-133行目) | ○ |
| C-09 | ffilter=flashでswfをフィルタリング | E-02 (129行目) | ○ |
| C-10 | ファイルサイズ制限1,324,000バイト | E-02 (18行目: sizeLimit) | ○ |
| C-11 | CKEditorFuncNumでエディタ連携 | E-02 (520-531行目) | ○ |
| C-12 | ベースフォルダは削除不可 | E-02 (388-395行目) | ○ |
| C-13 | ファイルアイコンが拡張子に応じて表示される | E-02 (203-233行目) | ○ |
| C-14 | ファイル選択でプレビュー表示 | E-02 (407-485行目) | ○ |
| C-15 | 画像プレビューはshowThumb.aspxで生成 | E-02 (428-432行目) | ○ |
| C-16 | モーダルダイアログでフォルダ作成・削除 | E-02 (377-401行目) | ○ |
| C-17 | セカンドアドミンのbReadOnlyで書き込み制限可能 | E-02 (20-24行目) | ○ |
| C-18 | 画面No.125-128がアセットマネージャーに対応 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ファイルアップロード機能はセキュリティリスクがあるため、ファイルタイプ制限の検証が重要

## 6) レビュアーチェックリスト（最小）
- [ ] allowedFileTypesで許可されたファイルタイプ以外がアップロードできないことを確認
- [ ] サイズ制限が正しく動作することを確認
- [ ] ベースフォルダ外へのパス操作ができないことを確認
- [ ] CKEditor連携が正しく動作することを確認
