---
generated_at: 2026-01-23 21:56:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-フォーム一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formList.asp` - フォーム一覧画面メイン処理
- E-02: `asp/includes/form.asp` - cls_formクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.132-136のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム一覧はbs_formList.aspで実装されている | E-01 | ○ |
| C-02 | セカンドアドミンのbForms権限チェックが行われる | E-01 (4行目) | ○ |
| C-03 | copyform.copy()でフォームコピーが実行される | E-01 (5-6行目) | ○ |
| C-04 | customer.formsでフォーム一覧を取得 | E-01 (7-8行目) | ○ |
| C-05 | フォームIDはencrypt関数で暗号化される | E-01 (8行目) | ○ |
| C-06 | bFormExport権限でデータエクスポート表示を制御 | E-01 (8行目: secondAdmin.bFormExport) | ○ |
| C-07 | プレビューはgetIconPPでポップアップ表示 | E-01 (8行目: class="QSPP") | ○ |
| C-08 | Excelエクスポートは別ウィンドウで開く | E-01 (8行目: window.open) | ○ |
| C-09 | コピー時に確認ダイアログが表示される | E-01 (8行目: confirm) | ○ |
| C-10 | cls_formクラスでフォームデータを管理 | E-02 (2-5行目) | ○ |
| C-11 | copy関数でフォームとフィールドをコピー | E-02 (839-851行目) | ○ |
| C-12 | fields関数でフォームフィールドを取得 | E-02 (233-249行目) | ○ |
| C-13 | tblFormテーブルからデータを取得 | E-02 (30行目: select * from tblForm) | ○ |
| C-14 | 画面No.132-136がフォーム管理機能に対応 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示と参照のみの機能

## 6) レビュアーチェックリスト（最小）
- [ ] フォーム一覧が正しく表示されることを確認
- [ ] フォームコピー機能が正しく動作することを確認
- [ ] データエクスポート権限による表示制御を確認
- [ ] CSRFトークン検証が正しく動作することを確認
