---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-パスワード変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_applyTotalPW.asp` - パスワード変更画面（5行）
- E-02: `asp/bs_process.asp` - 処理分岐ロジック（214行）
- E-03: `asp/includes/customer.asp` - cls_customerクラス（1637行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bPagesPW権限チェック | E-01（4行目） | ○ |
| C-02 | save_pw_total処理でapplyTotalPW呼び出し | E-02（162-166行目） | ○ |
| C-03 | delete_pw_total処理でremoveTotalPW呼び出し | E-02（157-161行目） | ○ |
| C-04 | cSaveAdminPW処理でsaveAdminPW呼び出し | E-02（176-184行目） | ○ |
| C-05 | パスワード確認一致チェック | E-02（178行目） | ○ |
| C-06 | SHA-256でハッシュ化 | E-03（1206行目） | ○ |
| C-07 | デフォルトパスワードチェック | E-03（1202-1204行目） | ○ |
| C-08 | applyTotalPWで3文字以上チェック | E-03（707-709行目） | ○ |
| C-09 | applyTotalPWで全ページsPw更新 | E-03（714行目） | ○ |
| C-10 | removeTotalPWでsTotalPW空文字に | E-03（721行目） | ○ |
| C-11 | removeTotalPWで全ページsPw削除 | E-03（724行目） | ○ |
| C-12 | saveAdminPW後に自動ログオン | E-03（1208行目: logon.logon） | ○ |
| C-13 | CSRF検証を実行 | E-02（158,163,177行目: checkCSRF） | ○ |
| C-14 | err_pwエラー（3文字未満） | E-03（709行目） | ○ |
| C-15 | pwnomatchエラー（不一致） | E-02（183行目） | ○ |
| C-16 | err_backsitepwエラー（デフォルトPW） | E-03（1204行目） | ○ |
| C-17 | 関連画面No.18,116 | E-05 | ○ |
| C-18 | イントラネットページには適用されない | E-03（714行目: bIntranet条件） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パスワード管理ロジックが全てソースコードで確認済み
- 0: 低リスク - SHA-256ハッシュ化の実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 全ページへのパスワード適用が正しく動作するか確認
- [ ] 自動ログオン後のセッション状態が正しいか確認
- [ ] デフォルトパスワードチェックが正しく動作するか確認
