---
generated_at: 2026-01-23 21:58:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-フォーム作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formEdit.asp` - フォーム編集画面メイン処理
- E-02: `asp/includes/form.asp` - cls_formクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.132-134のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム編集はbs_formEdit.aspで実装されている | E-01 | ○ |
| C-02 | セカンドアドミンのbForms権限チェックが行われる | E-01 (4行目) | ○ |
| C-03 | cls_formオブジェクトでフォームデータを管理 | E-01 (5行目) | ○ |
| C-04 | postBackで入力値の引き継ぎを制御 | E-01 (7-10行目) | ○ |
| C-05 | 他カスタマーのフォーム編集を防止 | E-01 (11-13行目) | ○ |
| C-06 | 保存ボタンでcheckCSRF、save、リダイレクト | E-01 (15-26行目) | ○ |
| C-07 | 削除ボタンでcheckCSRF、remove、リダイレクト | E-01 (27-31行目) | ○ |
| C-08 | 新規作成後はbs_formfields.aspへリダイレクト | E-01 (22行目) | ○ |
| C-09 | 編集後はbs_formList.aspへリダイレクト | E-01 (24行目) | ○ |
| C-10 | sQAalignで質問/回答配置を設定 | E-01 (33行目) | ○ |
| C-11 | bCaptchaでCAPTCHA認証を制御 | E-01 (33行目) | ○ |
| C-12 | bAutoResponderで自動返信機能を制御 | E-01 (40-45行目) | ○ |
| C-13 | bSendEmailでメール通知を制御 | E-01 (45行目) | ○ |
| C-14 | [QS_COPYSUBMISSION]で送信内容を含める | E-01 (38行目, 43行目) | ○ |
| C-15 | cls_formのcheck関数でバリデーション | E-02 (64-130行目) | ○ |
| C-16 | フィードバックとリダイレクトは排他 | E-02 (78-81行目) | ○ |
| C-17 | save関数でtblFormに保存 | E-02 (131-184行目) | ○ |
| C-18 | remove関数で関連データを含めて削除 | E-02 (210-232行目) | ○ |
| C-19 | 削除時にtblPage/tblCatalogのiFormIDをnullに更新 | E-02 (225-228行目) | ○ |
| C-20 | sScriptUponSubmissionはbApplication時のみ表示 | E-01 (45行目: customer.bApplication) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - sScriptUponSubmission機能はスクリプト実行を伴うためセキュリティ上の注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 必須項目のバリデーションが正しく動作することを確認
- [ ] フィードバック/リダイレクトの排他制御を確認
- [ ] 自動返信メールが正しく送信されることを確認
- [ ] 管理者通知メールが正しく送信されることを確認
- [ ] CSRFトークン検証が正しく動作することを確認
- [ ] 他カスタマーのフォームが編集できないことを確認
