---
generated_at: 2026-01-23 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-フォームフィールド管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：根拠不足（実測値なし）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formFields.asp` - フィールド一覧画面
- E-02: `asp/bs_FormFieldEdit.asp` - フィールド編集画面
- E-03: `asp/includes/FormField.asp` - FormFieldクラス定義
- E-04: `asp/includes/formFieldTypeList.asp` - フィールドタイプ定義
- E-05: `asp/includes/form.asp` - Formクラス定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bForms権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bForms` | ○ |
| C-02 | MoveUP/MoveDOWNアクションで並び替え | E-01 6-13行目: `case "MoveUP"`/`case "MoveDOWN"` | ○ |
| C-03 | CSRF検証が実行される | E-01 8行目, 11行目: `checkCSRF()` | ○ |
| C-04 | フィールドタイプは12種類定義 | E-04 2-14行目: sb_ff_定数群 | ○ |
| C-05 | iRangで表示順を管理 | E-03 8行目: `Public iRang`, 123行目: `rs("iRang")` | ○ |
| C-06 | フィールド名は必須 | E-03 64-67行目: `if isLeeg(sName) then check=false` | ○ |
| C-07 | フィールドタイプは必須 | E-03 60-63行目: `if isLeeg(sType) then check=false` | ○ |
| C-08 | select/radioタイプ時は値が必須 | E-03 68-71行目: `if (sType=sb_ff_select or sType=sb_ff_radio...) and isLeeg(sValues)` | ○ |
| C-09 | 新規作成時に表示順自動採番 | E-03 113-115行目: `select count(*) from tblFormField...iRang=...+1` | ○ |
| C-10 | iRang=1のフィールドは上移動不可 | E-03 209-211行目: `if convertGetal(iRang)=1 then exit function` | ○ |
| C-11 | moveUpで2レコード更新 | E-03 213-214行目: 2つのUPDATE文 | ○ |
| C-12 | 削除時に関連ファイルも削除 | E-03 245-265行目: fso.DeleteFile処理 | ○ |
| C-13 | 削除時にtblFormFieldValueも削除 | E-03 270行目: `delete from tblFormFieldValue` | ○ |
| C-14 | encrypt/decryptでID暗号化 | E-01 18行目: `encrypt(ffKey)`, E-02 21行目: `encrypt(FormField.iID)` | ○ |
| C-15 | sanitize関数でXSS対策 | E-02 23行目: `sanitize(FormField.sName)` | ○ |
| C-16 | tblFormFieldテーブルに保存 | E-03 111, 117行目: `select * from tblFormField` | ○ |
| C-17 | 画面No25,26,27と関連 | E-07 43-45行目: 機能41とマッピング | ○ |
| C-18 | パフォーマンス要件1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は実測またはSLAドキュメントが必要
  - 候補：性能テスト結果 / 運用ドキュメント / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: トランザクション制御なし（MoveUP/DOWN時の2 UPDATE）は低リスク
- 1: ファイル削除処理のエラーハンドリング確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] フィールドタイプの12種類が実運用で網羅されているか確認
- [ ] moveUp/moveDown時のデータ不整合リスクを許容するか確認
- [ ] パフォーマンス要件の妥当性を関係者と確認
