---
generated_at: 2026-01-23 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-フォーム送信データ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：実測値なし

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formExport.asp` - 送信データ一覧画面
- E-02: `asp/includes/form.asp` - Formクラス定義（submissions, removeAllSubmissions）
- E-03: `asp/includes/FormField.asp` - FormFieldクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bFormExport権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bFormExport` | ○ |
| C-02 | 個別削除はsubmission.remove()で実行 | E-01 11行目: `submission.remove(fields)` | ○ |
| C-03 | 全削除はform.removeAllSubmissions()で実行 | E-01 15行目: `form.removeAllSubmissions()` | ○ |
| C-04 | CSRF検証が実行される | E-01 10, 14行目: `checkCSRF()` | ○ |
| C-05 | 送信データは降順で取得 | E-02 828行目: `order by dCreatedTS desc` | ○ |
| C-06 | コメントタイプは表示から除外 | E-01 25行目: `if fields(cField).sType<>sb_ff_comment then` | ○ |
| C-07 | カタログ関連データがある場合のみカタログ列表示 | E-01 19-24行目: `showCatalog`フラグ制御 | ○ |
| C-08 | チェックボックス値はYes/Noに変換 | E-01 30-31行目: `convertCheckedYesNo(sanitize(values(cField)))` | ○ |
| C-09 | ファイル・画像はリンクとして表示 | E-01 32-37行目: `<a target=...href=...>` | ○ |
| C-10 | 削除確認ダイアログを表示 | E-01 47行目: `confirm('<%=l("areyousure")%>')` | ○ |
| C-11 | 件数を表示 | E-01 24行目: `<b><%= submissions.count%></b>` | ○ |
| C-12 | Excelエクスポートへのリンクを提供 | E-01 24行目: `getIcon("Excel","excel"...bs_formExcel.asp` | ○ |
| C-13 | データがない場合はメッセージ表示 | E-01 49行目: `else%><p align=center><%=l("nodata")%></p>` | ○ |
| C-14 | sanitize関数でXSS対策 | E-01 31, 42, 45行目: `sanitize(...)` | ○ |
| C-15 | 画面No28,29,30と関連 | E-05 46-48行目: 機能42とマッピング | ○ |
| C-16 | パフォーマンス要件3秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は実測またはSLAドキュメントが必要
  - 候補：性能テスト結果 / 運用ドキュメント / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: トランザクション制御なしは低リスク（削除は論理的に一貫）
- 1: 大量データ時のパフォーマンス確認を推奨
- 0: 全削除機能の誤操作リスクはconfirmダイアログで軽減

## 6) レビュアーチェックリスト（最小）
- [ ] 大量送信データ時のパフォーマンスを確認
- [ ] 全削除機能の運用ポリシーを確認
- [ ] ファイル添付データの削除が正しく行われることを確認
