---
generated_at: 2026-01-23 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-フォームデータExcel出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formExcel.asp` - Excel出力処理
- E-02: `asp/includes/form.asp` - Formクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bFormExport権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bFormExport` | ○ |
| C-02 | コメントタイプは出力から除外 | E-01 22行目: `if fields(cField).sType<>sb_ff_comment then` | ○ |
| C-03 | チェックボックス値はYes/Noに変換 | E-01 43行目: `convertCheckedYesNo(sanitize(values(cField)))` | ○ |
| C-04 | ファイル・画像はURLとして出力 | E-01 44-49行目: `linkUrls(customer.sVDUrl...)` | ○ |
| C-05 | カタログ関連データがある場合のみカタログ列出力 | E-01 9-14行目: `showCatalog`フラグ制御、17-19行目 | ○ |
| C-06 | ヘッダー行はGainsboro色 | E-01 16行目: `style='background-color:Gainsboro;'` | ○ |
| C-07 | cls_excelfile.export()でExcel変換 | E-01 64行目: `excelfile.export(table)` | ○ |
| C-08 | redirectLink()でダウンロード | E-01 65行目: `excelfile.redirectLink()` | ○ |
| C-09 | 送信データIDを出力 | E-01 32行目: `tableRow=tableRow& "<td>" & sKey & "</td>"` | ○ |
| C-10 | 送信日時を出力 | E-01 33行目: `formatTimeStamp(submission.dCreatedTS)` | ○ |
| C-11 | カタログ名を出力 | E-01 35行目: `submission.item.catalog.sName` | ○ |
| C-12 | アイテム名を出力 | E-01 36行目: `submission.item.sTitle` | ○ |
| C-13 | sanitize関数で値エスケープ | E-01 43, 51行目: `sanitize(...)` | ○ |
| C-14 | 画面No29と関連 | E-04 47行目: 機能43とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 大量データ時のタイムアウトリスク確認を推奨
- 0: HTMLテーブル形式のExcel出力は互換性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 大量データ時のExcel生成パフォーマンスを確認
- [ ] Excel出力形式が要件を満たしているか確認
- [ ] ファイルURLの出力形式が正しいか確認
