---
generated_at: 2026-01-23 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-フォームプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_formPreview.asp` - プレビュー画面
- E-02: `asp/includes/form.asp` - Formクラス定義（build関数）
- E-03: `asp/bs_formFields.asp` - フィールド一覧画面（呼び出し元）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bForms権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bForms` | ○ |
| C-02 | form.buildメソッドでHTML生成 | E-01 6行目: `form.build("bs_formPreview.asp","center","button",null)` | ○ |
| C-03 | アンカータグを生成 | E-02 565行目: `<a name='form"& encrypt(iId) &"'></a>` | ○ |
| C-04 | イントロ文を表示 | E-02 585行目: `<p>" & show(sIntro) & "</p>` | ○ |
| C-05 | 各フィールドタイプ別にHTML生成 | E-02 624-737行目: select case処理 | ○ |
| C-06 | CAPTCHA表示機能あり | E-02 745-756行目: `if bCaptcha then` | ○ |
| C-07 | 送信ボタンを生成 | E-02 775行目: `<input class='art-button' type='"& buttonType &"'...` | ○ |
| C-08 | リセットボタンを生成（設定時） | E-02 776-778行目: `if not isLeeg(sReset) then` | ○ |
| C-09 | ポップアップウィンドウで表示 | E-03 18行目: `class=""QSPP""` (ポップアップ用CSSクラス) | ○ |
| C-10 | 画面No27と関連 | E-05 45行目: 機能44とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: プレビュー機能は参照のみで低リスク
- 0: build関数は本番フォーム表示と共通のため品質は安定

## 6) レビュアーチェックリスト（最小）
- [ ] プレビュー表示が本番表示と一致することを確認
- [ ] 全フィールドタイプが正しくプレビューされることを確認
