---
generated_at: 2026-01-23 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-カタログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogList.asp` - カタログ一覧画面
- E-02: `asp/includes/catalog.asp` - Catalogクラス定義
- E-03: `asp/includes/catalogField.asp` - CatalogFieldクラス定義
- E-04: `asp/includes/catalogFileType.asp` - CatalogFileTypeクラス定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | MoveUP/MoveDOWNアクションで並び替え | E-01 6-13行目: `case "MoveUP"`/`case "MoveDOWN"` | ○ |
| C-03 | CSRF検証が実行される | E-01 8, 11行目: `checkCSRF()` | ○ |
| C-04 | customer.catalogsでカタログ一覧取得 | E-01 14-15行目: `set catalogs=customer.catalogs` | ○ |
| C-05 | catalogs(key).fieldsでフィールド一覧取得 | E-01 18行目: `set fields = catalogs(key).fields("")` | ○ |
| C-06 | catalogs(key).fileTypesでファイルタイプ一覧取得 | E-01 19行目: `set fileTypes = catalogs(key).fileTypes` | ○ |
| C-07 | フィールドが1件以上ある場合のみアイテム追加リンク表示 | E-01 19行目: `if fields.count>0 then...` | ○ |
| C-08 | フィールドはiRang順で取得 | E-02 255行目: `order by iRang asc` | ○ |
| C-09 | iRang=1のフィールドは上移動不可 | E-03 140-141行目: `if convertGetal(iRang)=1 then exit function` | ○ |
| C-10 | moveUpで2レコード更新 | E-03 143-144行目: 2つのUPDATE文 | ○ |
| C-11 | 新規カタログ作成リンクを表示 | E-01 15行目: `getArtLink("bs_catalogEdit.asp",l("newcatalog")...` | ○ |
| C-12 | 新規フィールド作成リンクを表示 | E-01 19行目: `bs_catalogFieldEdit.asp?iCatalogID=` | ○ |
| C-13 | 新規ファイルタイプ作成リンクを表示 | E-01 19行目: `bs_catalogFileTypeEdit.asp?iCatalogID=` | ○ |
| C-14 | アイテム一覧リンクを表示 | E-01 19行目: `bs_catalogItemSearch.asp?iCatalogID=` | ○ |
| C-15 | 画面No34と関連 | E-06 54行目: 機能45とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: カタログ一覧は参照・並び替えのみで低リスク
- 0: 並び替えの整合性チェックは実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 大量カタログ時の表示パフォーマンスを確認
- [ ] フィールド並び替えの動作を確認
