---
generated_at: 2026-01-23 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-カタログ作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogEdit.asp` - カタログ編集画面
- E-02: `asp/includes/catalog.asp` - Catalogクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | saveアクションで保存処理 | E-01 12-15行目: `case l("save")` | ○ |
| C-03 | deleteアクションで削除処理 | E-01 16-19行目: `case l("delete")` | ○ |
| C-04 | CSRF検証が実行される | E-01 13, 17行目: `checkCSRF()` | ○ |
| C-05 | カタログ名は必須 | E-02 86-89行目: `if isLeeg(sName) then check=false` | ○ |
| C-06 | アイテム名は必須 | E-02 90-93行目: `if isLeeg(sItemName) then check=false` | ○ |
| C-07 | フォーム連携時はリンクテキスト必須 | E-02 94-98行目: `if not isLeeg(iFormID) then if isLeeg(sFormTitle)` | ○ |
| C-08 | 新規作成時にdCreatedTS設定 | E-02 114行目: `rs("dCreatedTS")=now()` | ○ |
| C-09 | 更新時にdUpdatedTS設定 | E-02 127行目: `rs("dUpdatedTS")= now()` | ○ |
| C-10 | 保存後にRSSキャッシュクリア | E-02 148行目: `clearRSSCache` | ○ |
| C-11 | 削除時に関連アイテムも削除 | E-02 210-212行目: `copyItems(key).remove` | ○ |
| C-12 | 削除時に関連フィールドも削除 | E-02 213-215行目: `copyFields(key).remove` | ○ |
| C-13 | 削除時に関連ファイルタイプも削除 | E-02 216-218行目: `copyFiletypes(key).remove` | ○ |
| C-14 | 削除時にページ参照を解除 | E-02 220行目: `update tblPage set iCatalogID=null` | ○ |
| C-15 | QS_secCodeHiddenでCSRF対策 | E-01 28行目: `<%=QS_secCodeHidden%>` | ○ |
| C-16 | quotRepで出力エスケープ | E-01 29行目: `quotRep(catalog.sName)` | ○ |
| C-17 | encrypt/decryptでID暗号化 | E-01 28行目: `encrypt(catalog.iID)` | ○ |
| C-18 | 画面No35と関連 | E-04 58行目: 機能46とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: カタログ削除時の関連データ削除は慎重に（確認ダイアログあり）
- 0: バリデーション処理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] カタログ削除時の関連データ削除動作を確認
- [ ] RSSビューテンプレートのプレースホルダーが正しく動作することを確認
- [ ] フォーム連携設定が正しく動作することを確認
