---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-カタログフィールド管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogFieldEdit.asp` - フィールド編集画面
- E-02: `asp/includes/catalogField.asp` - CatalogFieldクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | saveアクションで保存処理 | E-01 12-15行目: `case l("save")` | ○ |
| C-03 | deleteアクションで削除処理 | E-01 16-19行目: `case l("delete")` | ○ |
| C-04 | CSRF検証が実行される | E-01 13, 17行目: `checkCSRF()` | ○ |
| C-05 | フィールド名は必須 | E-02 47-50行目: `if isLeeg(sName) then check=false` | ○ |
| C-06 | タイプは必須 | E-02 43-46行目: `if isLeeg(sType) then check=false` | ○ |
| C-07 | セレクトタイプ時は選択肢必須 | E-02 51-54行目: `if sType=sb_select and isLeeg(sValues)` | ○ |
| C-08 | 新規作成時に表示順自動採番 | E-02 70-72行目: `select count(*) from tblCatalogField...iRang=...+1` | ○ |
| C-09 | 削除時に関連アイテムフィールド値も削除 | E-02 163行目: `delete from tbCatalogItemFields where iFieldId` | ○ |
| C-10 | 削除時に表示順再計算 | E-02 161行目: `update tblCatalogField set iRang=iRang-1` | ○ |
| C-11 | 最後のフィールド削除不可 | E-01 22行目: `if...catalog.fields("").count>1 then` | ○ |
| C-12 | 新規フィールド作成時に既存アイテムに値追加 | E-02 89-102行目: `tbCatalogItemFields`へのINSERT | ○ |
| C-13 | bPublicプロパティで公開/非公開制御 | E-02 9行目: `Public bPublic` | ○ |
| C-14 | bSearchFieldで検索対象制御 | E-02 9行目: `Public bSearchField` | ○ |
| C-15 | bMandatoryで必須/任意制御 | E-02 9行目: `Public bMandatory` | ○ |
| C-16 | encrypt/decryptでID暗号化 | E-01 21行目: `encrypt(catalogField.iID)` | ○ |
| C-17 | 画面No36と関連 | E-04 59行目: 機能47とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: フィールド削除時の関連データ削除は適切に実装されている
- 0: 最後のフィールド削除防止機能あり

## 6) レビュアーチェックリスト（最小）
- [ ] 新規フィールド作成時に既存アイテムへの値追加が正しく動作することを確認
- [ ] フィールド削除時の関連データ削除が正しく動作することを確認
