---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-カタログアイテム管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogItemEdit.asp` - アイテム編集画面
- E-02: `asp/includes/catalogItem.asp` - CatalogItemクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | saveアクションで保存処理 | E-01 16-21行目: `case l("save")` | ○ |
| C-03 | deleteアクションで削除処理 | E-01 22-25行目: `case l("delete")` | ○ |
| C-04 | uploadattachmentでファイルアップロード画面へ | E-01 26-31行目: `case l("uploadattachment")` | ○ |
| C-05 | uploadpicで画像アップロード画面へ | E-01 32-37行目: `case l("uploadpic")` | ○ |
| C-06 | deletepicで画像削除 | E-01 38-42行目: `case l("deletepic")` | ○ |
| C-07 | CSRF検証が実行される | E-01 12, 17, 23等: `checkCSRF()` | ○ |
| C-08 | タイトルは必須 | E-02 82-85行目: `if isLeeg(sTitle) then check=false` | ○ |
| C-09 | 必須フィールドのバリデーション | E-02 87-97行目: `if catalogFields(catalogField).bMandatory` | ○ |
| C-10 | タイトルは255文字以内 | E-02 116行目: `left(sTitle,255)` | ○ |
| C-11 | 削除時に画像も削除 | E-02 176行目: `removePic()` | ○ |
| C-12 | 削除時にファイルも削除 | E-02 178-181行目: `cFiles(cFile).remove()` | ○ |
| C-13 | 削除時にフィールド値も削除 | E-02 190行目: `delete from tbCatalogItemFields` | ○ |
| C-14 | 削除時に送信データも削除 | E-02 182-187行目: `cSubmissions(cSub).remove` | ○ |
| C-15 | 保存時にRSSキャッシュクリア | E-02 147行目: `catalog.clearRSSCache` | ○ |
| C-16 | フィールド値は全削除→再挿入 | E-02 131-145行目: DELETE→INSERT処理 | ○ |
| C-17 | 新規作成時にdCreatedTS設定 | E-02 112行目: `rs("dCreatedTS")=now()` | ○ |
| C-18 | 画面No38と関連 | E-04 61-63行目: 機能48とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: フィールド値の全削除→再挿入方式は大量データ時に注意
- 0: 削除時の関連データ削除は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 大量フィールド時のパフォーマンスを確認
- [ ] アイテム削除時の関連データ削除が正しく動作することを確認
- [ ] 画像・ファイルアップロード機能が正しく動作することを確認
