---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-カタログアイテム検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogItemSearch.asp` - 検索画面
- E-02: `asp/includes/ItemSearch.asp` - cls_itemSearchクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | cls_itemSearchで検索処理 | E-01 5行目: `set itemSearch=new cls_itemSearch` | ○ |
| C-03 | catalog.fields("search")で検索フィールド取得 | E-01 7行目: `set catalogFields=itemSearch.catalog.fields("search")` | ○ |
| C-04 | inputFieldsでフィールド値を管理 | E-02 6行目: `Public inputFields`、20行目: Dictionary生成 | ○ |
| C-05 | dateFieldsで日付範囲を管理 | E-02 7行目: `Public dateFields`、21行目: Dictionary生成 | ○ |
| C-06 | iItemIDでコピー処理 | E-01 18-20行目: `if isNumeriek(catalogItem.iId) then catalogItem.copy()` | ○ |
| C-07 | タイトルはLIKE検索 | E-02 63行目: `tblCatalogItem.sTitle like '%keyword%'` | ○ |
| C-08 | タイトル空白区切りでOR検索 | E-02 61-65行目: `split(sTitle," ")...OR` | ○ |
| C-09 | フィールド値はサブクエリで検索 | E-02 73行目: `in (select iItemID from tbCatalogItemFields where...like)` | ○ |
| C-10 | 日付範囲はfrom-untillで検索 | E-02 86-106行目: from/untill処理、sValue>=fromDate and sValue<=untillDate | ○ |
| C-11 | pageSize初期値9999 | E-02 26行目: `pageSize=9999` | ○ |
| C-12 | absolutepage初期値1 | E-02 31行目: `absolutepage=1` | ○ |
| C-13 | mode判定でsearch/excel分岐 | E-02 280-292行目: `select case mode` | ○ |
| C-14 | Excel出力はcls_excelFile使用 | E-02 287-290行目: `set excelFile=new cls_excelFile...export` | ○ |
| C-15 | cleanup関数でサニタイズ | E-02 63, 73行目: `cleanup(splitValues(lV))`, `cleanUp(inputFields)` | ○ |
| C-16 | quotRepで出力エスケープ | E-01 21行目: `quotRep(itemSearch.sTitle)` | ○ |
| C-17 | フィールドIDをencrypt | E-01 22行目: `encrypt(catalogField)` | ○ |
| C-18 | 検索件数=recordCount/searchFields.count | E-02 278行目: `recordCount=recordCount/searchFields.count` | ○ |
| C-19 | 画面No39と関連 | E-04 64行目: 機能49とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 動的SQL構築のため、大量データ時のパフォーマンス注意
- 0: 検索フィールドのencrypt/decryptは適切に実装されている
- 0: cleanup関数によるSQLインジェクション対策あり

## 6) レビュアーチェックリスト（最小）
- [ ] 大量アイテム時の検索パフォーマンスを確認
- [ ] 複数フィールド条件での検索が正しく動作することを確認
- [ ] Excel出力が正しく動作することを確認
- [ ] アイテムコピー機能が正しく動作することを確認
