---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-サイト基本設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_admin.asp` - 基本設定画面（11行）
- E-02: `asp/bs_process.asp` - 処理分岐ロジック（214行）
- E-03: `asp/includes/customer.asp` - cls_customerクラス（1637行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bSetupGeneral権限チェック | E-01（4行目） | ○ |
| C-02 | saveAdmin処理でcustomer.save呼び出し | E-02（122行目） | ○ |
| C-03 | メニューキャッシュクリア | E-02（124行目: clearMenuCache） | ○ |
| C-04 | メイン管理者のみURL編集可能 | E-02（105-108行目: if logon.currentPW=customer.adminPassword） | ○ |
| C-05 | URL小文字化 | E-03（313行目: lcase(sURL)） | ○ |
| C-06 | URL末尾スラッシュ除去 | E-03（310-312行目） | ○ |
| C-07 | 代替ドメイン自動設定 | E-03（341-347行目） | ○ |
| C-08 | siteName取得 | E-02（110行目） | ○ |
| C-09 | siteTitle取得 | E-02（111行目） | ○ |
| C-10 | language取得 | E-02（117行目） | ○ |
| C-11 | sDatumFormat取得 | E-02（118行目） | ○ |
| C-12 | googleAnalytics取得 | E-02（115行目） | ○ |
| C-13 | CSRF検証 | E-02（104行目: checkCSRF） | ○ |
| C-14 | err_mandatoryエラー | E-03（248-250行目） | ○ |
| C-15 | err_urlエラー | E-03（251-253行目） | ○ |
| C-16 | 関連画面No.86,136,137,147,148,187 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定保存ロジックが全てソースコードで確認済み
- 0: 低リスク - URL整形処理が明確

## 6) レビュアーチェックリスト（最小）
- [ ] URL整形処理が正しく動作するか確認
- [ ] 代替ドメインの自動設定が正しいか確認
- [ ] セカンドアドミン時のURL編集制限が正しく動作するか確認
