---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-カタログファイルタイプ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_catalogFileTypeEdit.asp` - ファイルタイプ編集画面
- E-02: `asp/includes/catalogFileType.asp` - cls_CatalogFileTypeクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCatalog権限が必要 | E-01 4行目: `logon.hasaccess secondAdmin.bCatalog` | ○ |
| C-02 | saveアクションで保存処理 | E-01 7-10行目: `case l("save")` | ○ |
| C-03 | deleteアクションで削除処理 | E-01 11-14行目: `case l("delete")` | ○ |
| C-04 | CSRF検証が実行される | E-01 8, 12行目: `checkCSRF()` | ○ |
| C-05 | タイプ名は必須 | E-02 28-31行目: `if isLeeg(sName) then check=false` | ○ |
| C-06 | 削除時に関連ファイルも削除 | E-02 62行目: `delete from tblCatalogItemFiles where iFileTypeID` | ○ |
| C-07 | 削除時に本体削除 | E-02 64行目: `delete from tblCatalogFileType where iId` | ○ |
| C-08 | QS_secCodeHiddenでCSRF対策 | E-01 15行目: `<%=QS_secCodeHidden%>` | ○ |
| C-09 | quotRepで出力エスケープ | E-01 15行目: `quotRep(catalogFileType.sName)` | ○ |
| C-10 | encrypt/decryptでID暗号化 | E-01 15行目: `encrypt(catalogFileType.iID)` | ○ |
| C-11 | 削除確認ダイアログ | E-01 15行目: `confirm('<%=l("areyousure")%>')` | ○ |
| C-12 | copy関数でカタログコピー対応 | E-02 72-78行目: `public function copy(catID)` | ○ |
| C-13 | catalog関数でカタログ情報取得 | E-02 68-71行目: `public function catalog` | ○ |
| C-14 | 画面No37と関連 | E-04 60行目: 機能50とマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 関連ファイル削除処理は適切に実装されている
- 0: シンプルなCRUD機能のため複雑な処理なし

## 6) レビュアーチェックリスト（最小）
- [ ] ファイルタイプ削除時に関連ファイルが正しく削除されることを確認
- [ ] カタログコピー時にファイルタイプも正しく複製されることを確認
