---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-フィード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_feedList.asp` - フィード一覧画面（4行目: セキュリティチェック、5-7行目: コピー処理、8-9行目: 一覧取得）
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義（31-64行目: pick関数、96-147行目: save関数、193-200行目: copy関数）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（53行目: フィード一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（100-103行目: 画面68との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのフィード権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bFeed） | ○ |
| C-02 | customer.feedsでフィード一覧を取得 | E-01（9行目: set feeds=customer.feeds） | ○ |
| C-03 | コピー処理はcls_feedのcopyメソッドで実行 | E-01（5-7行目: copyFeed.copy()）、E-02（193-200行目） | ○ |
| C-04 | コピー成功時は新フィード編集画面へリダイレクト | E-01（7行目: Response.Redirect ("bs_feedEdit.asp?iFeedID="&encrypt(copyFeed.iId))） | ○ |
| C-05 | フィード名をクリックすると編集画面へ遷移 | E-01（10行目: href="bs_feedEdit.asp?ifeedID="） | ○ |
| C-06 | プレビューアイコンでプレビュー画面へ遷移 | E-01（10行目: getIcon(...,"bs_feedPreview.asp?ifeedID="...)) | ○ |
| C-07 | コピーアイコンは確認ダイアログ付き | E-01（10行目: javascript:return confirm(...areyousuretocopy...)) | ○ |
| C-08 | コピー操作時はCSRFトークン検証（QS_secCodeURL） | E-01（10行目: bs_feedList.asp?"&QS_secCodeURL&"&amp;iFeedID=") | ○ |
| C-09 | 埋め込みコードは[QS_FEED:コード]形式で表示 | E-01（10行目: value="[QS_FEED:"&sanitize(feeds(feedkey).sCode)&"]") | ○ |
| C-10 | フィードがない場合は「nofeed」メッセージを表示 | E-01（10行目: else ... l("nofeed")） | ○ |
| C-11 | コピー時にsCodeは空にリセットされる | E-02（197行目: sCode=""） | ○ |
| C-12 | コピー時に名前は「コピー - 元の名前」形式になる | E-02（196行目: sName=l("copyof") & " " & sName） | ○ |
| C-13 | 新規フィード作成リンクが表示される | E-01（9行目: getArtLink("bs_feedEdit.asp",l("newfeed"),...)) | ○ |
| C-14 | 機能Noは53で機能名は「フィード一覧」 | E-03（53行目: "53","管理画面/フィード","フィード一覧"） | ○ |
| C-15 | 画面68（フィード一覧）が主機能として関連 | E-04（100行目: "68","フィード一覧","53","フィード一覧","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] customer.feedsの実装詳細（customer.asp）を確認
- [ ] フィード数が多い場合のパフォーマンスを確認（ページングなし）
- [ ] CSRFトークン検証の実装を確認
