---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-フィード作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_feedEdit.asp` - フィード編集画面（4行目: セキュリティチェック、9-20行目: ボタンアクション処理）
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義（65-95行目: check関数、96-147行目: save関数、148-181行目: getRequestValues、182-192行目: remove関数）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（54行目: フィード作成・編集）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（102行目: 画面69との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのフィード権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bFeed） | ○ |
| C-02 | PostBack時にgetRequestValuesで入力値を取得 | E-01（8行目: if postBack then feed.getRequestValues()） | ○ |
| C-03 | 保存ボタン押下時にCSRF検証が行われる | E-01（11行目: checkCSRF()） | ○ |
| C-04 | 保存成功時はフィード一覧へリダイレクト | E-01（14行目: Response.Redirect ("bs_feedList.asp")） | ○ |
| C-05 | 削除ボタン押下時にCSRF検証とremove処理 | E-01（16-18行目: checkCSRF(), feed.remove） | ○ |
| C-06 | sNameが空の場合はerr_mandatoryエラー | E-02（67-70行目: if isLeeg(sName) then ... message.AddError("err_mandatory")） | ○ |
| C-07 | sUrlとsUrlsが両方空の場合はerr_mandatoryエラー | E-02（71-74行目: if isLeeg(sUrl) and isLeeg(sUrls) then） | ○ |
| C-08 | sUrlからhttp://とhttps://を自動除去 | E-02（75-76行目: sUrl=replace(sUrl,"http://","",1,-1,1)） | ○ |
| C-09 | sCodeが重複している場合はerr_doublefeedエラー | E-02（86-93行目: if clng(checkRS(0))>0 then ... err_doublefeed） | ○ |
| C-10 | 保存時にcustomer.cacheFeeds()でキャッシュ更新 | E-02（145行目: customer.cacheFeeds()） | ○ |
| C-11 | 保存時にapplication変数のフィードキャッシュをクリア | E-02（146行目: application(QS_CMS_cacheFEED & iId)=""） | ○ |
| C-12 | 削除時にtblPageのiFeedIDをnullに更新 | E-02（185行目: db.execute("update tblPage set ifeedID=null where ifeedID="& iId)） | ○ |
| C-13 | 削除時にtblFeedからレコードを削除 | E-02（187行目: db.execute("delete from tblfeed where iId="& iId)） | ○ |
| C-14 | getRequestValuesでsCodeを大文字に変換 | E-02（156行目: sCode = ucase(convertStr(Request.Form ("sCode")))） | ○ |
| C-15 | iMaxItemsは1〜100の範囲で選択 | E-01（22行目: numberList(1,100,1,feed.iMaxItems)） | ○ |
| C-16 | iCacheは0〜14400秒の範囲で選択 | E-01（22行目: numberList(0,14400,30,feed.iCache)） | ○ |
| C-17 | cls_fullSearchでフィード使用箇所を検索 | E-01（27-35行目: set fsearch=new cls_fullSearch ... fsearch.search()） | ○ |
| C-18 | 検索パターンは[QS_FEED:コード]形式 | E-01（29行目: fsearch.pattern="\[QS_FEED:+("&feed.sCode&")+[\]]") | ○ |
| C-19 | 機能Noは54で機能名は「フィード作成・編集」 | E-03（54行目: "54","管理画面/フィード","フィード作成・編集"） | ○ |
| C-20 | 画面69（フィード編集）が主機能として関連 | E-04（102行目: "69","フィード編集","54","フィード作成・編集","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 外部RSSフィード取得時のセキュリティ（SSRF対策）を確認
- [ ] テンプレート変数の処理でXSS脆弱性がないか確認
- [ ] bEnableJS=falseの場合のJavaScript除去が適切か確認
