---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-フィードプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_feedPreview.asp` - フィードプレビュー画面（4行目: セキュリティチェック、5-6行目: フィード取得とビルド）
- E-02: `asp/includes/feed.asp` - cls_feedクラス定義（201-497行目: build関数）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（55行目: フィードプレビュー）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（103行目: 画面70との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのフィード権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bFeed） | ○ |
| C-02 | cls_feedインスタンス生成時にiFeedIDから自動pick | E-01（5行目: set feed=new cls_feed）、E-02（25行目: pick(decrypt(request("ifeedId")))） | ○ |
| C-03 | feed.build()でHTML生成 | E-01（6行目: Response.write feed.build()） | ○ |
| C-04 | キャッシュの有効性をチェックしてから外部取得 | E-02（203-204行目: if isEmpty(application(...)...) or cdate(now())>cdate(application(...TS))) | ○ |
| C-05 | MSXML2.DOMDocumentでフィードを取得 | E-02（258-259行目: Set xmlDOM = Server.CreateObject("msxml2.DOMDocument")） | ○ |
| C-06 | RSS形式とATOM形式の両方に対応 | E-02（285-300行目: getElementsByTagName("rss"), getElementsByTagName("feed")の判定） | ○ |
| C-07 | テンプレート変数を実際の値に置換 | E-02（392-410行目: ItemContent = Replace(ItemContent,"{LINK}"...,"{TITLE}"...など） | ○ |
| C-08 | キャッシュにビルド結果を保存 | E-02（450-451行目: application(QS_CMS_cacheFEED & iId)=build） | ○ |
| C-09 | bRandom=trueの場合はランダム順に表示 | E-02（457-480行目: if bRandom then ... SortDictionary2...） | ○ |
| C-10 | bEnableJS=falseの場合はJavaScript除去 | E-02（483-486行目: if convertBool(bEnableJS) then...else build=removeJS(...)） | ○ |
| C-11 | 機能Noは55で機能名は「フィードプレビュー」 | E-03（55行目: "55","管理画面/フィード","フィードプレビュー"） | ○ |
| C-12 | 画面70（フィードプレビュー）が主機能として関連 | E-04（103行目: "70","フィードプレビュー","55","フィードプレビュー","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 外部フィード取得失敗時のエラーハンドリングを確認
- [ ] On Error Resume Next使用によるエラー処理の適切性を確認
- [ ] キャッシュTSの更新タイミングを確認
