---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-ギャラリー作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_galleryEdit.asp` - ギャラリー編集画面（4行目: セキュリティチェック、15-30行目: ボタンアクション処理、109-176行目: Nivo Slider設定）
- E-02: `asp/includes/gallery.asp` - cls_galleryクラス定義（109-132行目: check関数、133-193行目: save関数、194-268行目: getRequestValues）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（57行目: ギャラリー作成・編集）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（51行目: 画面32との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのギャラリー権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bGallery） | ○ |
| C-02 | PostBack時にgetRequestValuesで入力値を取得 | E-01（10-12行目: if postBack then gallery.getRequestValues()） | ○ |
| C-03 | 保存ボタン押下時にCSRF検証が行われる | E-01（17行目: checkCSRF()） | ○ |
| C-04 | 保存成功時はギャラリー一覧へリダイレクト | E-01（23行目: Response.Redirect ("bs_galleryList.asp")） | ○ |
| C-05 | プレビューボタン押下時はプレビュー画面へリダイレクト | E-01（21行目: Response.Redirect ("bs_gallerypreview.asp?iGalleryID=...")） | ○ |
| C-06 | 削除ボタン押下時にremove処理 | E-01（27-28行目: gallery.remove ... Response.Redirect） | ○ |
| C-07 | sNameが空の場合はerr_mandatoryエラー | E-02（111-114行目: if isLeeg(sName) then ... message.AddError("err_mandatory")） | ○ |
| C-08 | sPathが空の場合はerr_mandatoryエラー | E-02（115-118行目: if isLeeg(sPath) then） | ○ |
| C-09 | sCodeが空の場合はerr_mandatoryエラー | E-02（119-122行目: if isLeeg(sCode) then） | ○ |
| C-10 | sCodeが重複している場合はerr_doublefeedエラー | E-02（123-131行目: if clng(checkRS(0))>0 then ... err_doublefeed） | ○ |
| C-11 | 保存時にcustomer.cacheGalleries()でキャッシュ更新 | E-02（191行目: customer.cacheGalleries()） | ○ |
| C-12 | 保存時にapplication変数のギャラリーキャッシュをクリア | E-02（192行目: application(QS_CMS_cacheGallery & iId)=""） | ○ |
| C-13 | Nivo Slider選択時はキャプション・URLをsNSImgLinksに保存 | E-02（246-267行目: if sType=QS_gallery_NS then ... sNSImgLinks） | ○ |
| C-14 | 画像フォルダ選択にcls_fileexplorerを使用 | E-01（46行目: fe.SelectBoxFolders(...gallery.sPath)） | ○ |
| C-15 | ギャラリータイプ選択にcls_galleryTypeListを使用 | E-01（47行目: galleryTypeList.showSelected("option",gallery.sType)） | ○ |
| C-16 | 使用箇所検索でcls_fullSearchを使用 | E-01（184-194行目: set fsearch=new cls_fullSearch ... fsearch.search()） | ○ |
| C-17 | 機能Noは57で機能名は「ギャラリー作成・編集」 | E-03（57行目: "57","管理画面/ギャラリー","ギャラリー作成・編集"） | ○ |
| C-18 | 画面32（ギャラリー編集）が主機能として関連 | E-04（51行目: "32","ギャラリー編集","57","ギャラリー作成・編集","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] sNSImgLinksのデータ形式（タブ・改行区切り）が正しく処理されるか確認
- [ ] 画像フォルダパス選択時のパストラバーサル対策を確認
- [ ] Nivo Sliderの画像数が多い場合のパフォーマンスを確認
