---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-ギャラリープレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_galleryPreview.asp` - ギャラリープレビュー画面（2行目: includeNS設定、4-6行目: ギャラリー取得とビルド）
- E-02: `asp/includes/gallery.asp` - cls_galleryクラス定義（289-677行目: build関数）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（58行目: ギャラリープレビュー）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（53行目: 画面33との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのギャラリー権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bGallery） | ○ |
| C-02 | cls_galleryインスタンス生成時にiGalleryIDから自動pick | E-01（5行目: set gallery=new cls_gallery）、E-02（38行目: pick(decrypt(request("iGalleryID")))） | ○ |
| C-03 | backsitePV=trueを設定 | E-01（6行目: gallery.backsitePV=true） | ○ |
| C-04 | gallery.build()でHTML生成 | E-01（7行目: gDump=treatconstants(gallery.build(),true)） | ○ |
| C-05 | includeNS=trueでNivo Sliderリソースを読み込み | E-01（2行目: includeNS=true） | ○ |
| C-06 | 修正ボタンでギャラリー編集画面へ遷移 | E-01（7行目: onclick="javascript:location.assign('bs_galleryEdit.asp?iGalleryID=..."） | ○ |
| C-07 | FileSystemObjectでフォルダ・ファイルを取得 | E-02（307行目: set fso = server.CreateObject ("scripting.filesystemobject")） | ○ |
| C-08 | フォルダが存在しない場合はエラーメッセージ表示 | E-02（308-309行目: if not fso.FolderExists ... build="<font color='Red'><b>" & ... & "</b> <u>does not exist</u>!"） | ○ |
| C-09 | iSortImagesByに従って画像をソート | E-02（321-337行目: select case convertgetal(iSortImagesBy)） | ○ |
| C-10 | Nivo Slider時はincludeNSフラグを設定 | E-02（460行目: includeNS=true） | ○ |
| C-11 | 機能Noは58で機能名は「ギャラリープレビュー」 | E-03（58行目: "58","管理画面/ギャラリー","ギャラリープレビュー"） | ○ |
| C-12 | 画面33（ギャラリープレビュー）が主機能として関連 | E-04（53行目: "33","ギャラリープレビュー","58","ギャラリープレビュー","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 画像フォルダ内のファイル数が多い場合のパフォーマンスを確認
- [ ] backsitePVによるナビゲーション非表示が正しく機能するか確認
- [ ] 各ギャラリータイプ（SS/SC/NS）のプレビュー表示を確認
