---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-投票（Poll）一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_pollList.asp` - 投票一覧画面（4行目: セキュリティチェック、5-7行目: コピー処理、8-9行目: 一覧取得）
- E-02: `asp/includes/poll.asp` - cls_pollクラス定義（95-125行目: pick関数、147-186行目: save関数、381-387行目: copy関数）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（59行目: 投票（Poll）一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（93-94行目: 画面63との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンの投票権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bPoll） | ○ |
| C-02 | customer.pollsで投票一覧を取得 | E-01（9行目: set polls=customer.polls） | ○ |
| C-03 | コピー処理はcls_pollのcopyメソッドで実行 | E-01（5-7行目: copyPoll.copy()）、E-02（381-387行目） | ○ |
| C-04 | コピー成功時は新投票編集画面へリダイレクト | E-01（7行目: Response.Redirect ("bs_pollEdit.asp?iPollID=" & encrypt(copyPoll.iId))） | ○ |
| C-05 | 投票質問をクリックすると編集画面へ遷移 | E-01（10行目: href="bs_pollEdit.asp?iPollID="） | ○ |
| C-06 | コピーアイコンは確認ダイアログ付き | E-01（10行目: javascript:return confirm(...areyousuretocopy...)) | ○ |
| C-07 | コピー操作時はCSRFトークン検証（QS_secCodeURL） | E-01（10行目: bs_pollList.asp?"&QS_secCodeURL&"&amp;ipollID=") | ○ |
| C-08 | 埋め込みコードは[QS_POLL:コード]形式で表示 | E-01（10行目: value="[QS_POLL:"&sanitize(polls(pollkey).sCode)&"]") | ○ |
| C-09 | 投票がない場合は「nopoll」メッセージを表示 | E-01（10行目: else ... l("nopoll")） | ○ |
| C-10 | コピー時にsCodeはランダム生成される | E-02（384行目: sCode=GeneratePassword） | ○ |
| C-11 | 新規投票作成リンクが表示される | E-01（9行目: getArtLink("bs_pollEdit.asp",l("newpoll"),...)) | ○ |
| C-12 | Questionsディクショナリで選択肢を管理 | E-02（20-61行目: set Questions=server.CreateObject ("scripting.dictionary") ... Questions.Add） | ○ |
| C-13 | 機能Noは59で機能名は「投票（Poll）一覧」 | E-03（59行目: "59","管理画面/投票","投票（Poll）一覧"） | ○ |
| C-14 | 画面63（投票一覧）が主機能として関連 | E-04（93行目: "63","投票一覧","59","投票（Poll）一覧","主機能"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] customer.pollsの実装詳細（customer.asp）を確認
- [ ] 投票数が多い場合のパフォーマンスを確認（ページングなし）
- [ ] CSRFトークン検証の実装を確認
