---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-SEO設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_admin.asp` - 基本設定画面（11行）
- E-02: `asp/bs_process.asp` - 処理分岐ロジック（214行）
- E-03: `asp/includes/customer.asp` - cls_customerクラス（1637行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bSetupGeneral権限チェック | E-01（4行目） | ○ |
| C-02 | keywords項目がフォームに存在 | E-01（10行目: input name="keywords"） | ○ |
| C-03 | sDescription項目がフォームに存在 | E-01（10行目: textarea name="sDescription"） | ○ |
| C-04 | copyRight項目がフォームに存在 | E-01（10行目: input name="copyRight"） | ○ |
| C-05 | webmaster項目がフォームに存在 | E-01（10行目: input name="webmaster"） | ○ |
| C-06 | sHeader項目がフォームに存在 | E-01（10行目: textarea name="sHeader"） | ○ |
| C-07 | saveAdmin処理でkeywords取得 | E-02（114行目: customer.keywords = Request.Form） | ○ |
| C-08 | saveAdmin処理でsDescription取得 | E-02（109行目: customer.sDescription = Request.Form） | ○ |
| C-09 | saveAdmin処理でcopyRight取得 | E-02（113行目: customer.copyRight = Request.Form） | ○ |
| C-10 | saveAdmin処理でwebmaster取得 | E-02（119行目: customer.webmaster = Request.Form） | ○ |
| C-11 | saveAdmin処理でsHeader取得 | E-02（116行目: customer.sHeader = Request.Form） | ○ |
| C-12 | CSRF検証を実行 | E-02（104行目: checkCSRF） | ○ |
| C-13 | customer.save()でDB保存 | E-02（122行目） | ○ |
| C-14 | 関連画面No.86,136,137 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SEO設定処理が全てソースコードで確認済み
- 0: 低リスク - フォーム入力から保存までの流れが明確

## 6) レビュアーチェックリスト（最小）
- [ ] SEO設定がフロントサイトのMETAタグに正しく反映されるか確認
- [ ] sHeaderの直接HTML記述がXSSなどのセキュリティリスクとならないか確認
- [ ] keywordsの最大2048文字制限が正しく動作するか確認
