---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-投票作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_pollEdit.asp` - 投票編集画面（4行目: セキュリティチェック、5-6行目: 初期化、12-26行目: ボタンアクション、27-29行目: フォーム表示）
- E-02: `asp/includes/poll.asp` - cls_pollクラス定義（18-65行目: Class_Initialize、66-83行目: getRequestValues、136-146行目: check、147-186行目: save、187-204行目: remove/reset）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（60行目: 投票作成・編集）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（95行目: 画面64との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンの投票権限チェックが行われる | E-01（4行目: logon.hasaccess secondAdmin.bPoll） | ○ |
| C-02 | cls_pollインスタンス生成時にiPollIDから自動pick | E-01（5行目: set poll=new cls_poll）、E-02（63行目: pick(decrypt(request("iPollID")))） | ○ |
| C-03 | bCanVote=falseを設定し管理画面からの投票を防止 | E-01（6行目: poll.bCanVote=false） | ○ |
| C-04 | 保存ボタン押下時にCSRF検証が行われる | E-01（14行目: checkCSRF()） | ○ |
| C-05 | 保存成功時は投票一覧へリダイレクト | E-01（17行目: Response.Redirect ("bs_pollList.asp")） | ○ |
| C-06 | 削除ボタン押下時にCSRF検証とremove処理 | E-01（20-22行目: checkCSRF() ... poll.remove ... Response.Redirect） | ○ |
| C-07 | リセットボタン押下時にCSRF検証とreset処理 | E-01（24-26行目: checkCSRF() ... poll.reset ... Response.Redirect） | ○ |
| C-08 | sQuestionが空の場合はerr_mandatoryエラー | E-02（138-141行目: if isLeeg(sQuestion) then ... message.AddError("err_mandatory")） | ○ |
| C-09 | sCodeが空の場合はerr_mandatoryエラー | E-02（142-145行目: if isLeeg(sCode) then ... message.AddError("err_mandatory")） | ○ |
| C-10 | Questionsディクショナリで選択肢を管理（最大15個） | E-02（20-61行目: Questions.Add 1,arr ... Questions.Add 12,arr、78行目: for i=1 to 15） | ○ |
| C-11 | 各選択肢にデフォルト色が設定される | E-02（26-61行目: arr(0)="#67645F" ... "#9A948F" ... "#CDC5BF" 等） | ○ |
| C-12 | 削除時はtblPollVoteとtblPollを順に削除 | E-02（190行目: delete from tblPollVote where iPollID=...、192行目: delete from tblPoll where iId=...） | ○ |
| C-13 | リセット時はtblPollVoteを削除しdResetDateを更新 | E-02（199行目: delete from tblPollVote where iPollID=...、201行目: dResetDate=now()、202行目: save()） | ○ |
| C-14 | showresults関数で投票結果を棒グラフ形式で生成 | E-02（355-378行目: showresults="<table..." ... "<div style=\"height:10px;width:" & percent & "%..."） | ○ |
| C-15 | 投票数ラベルの[NMBR]を実際の投票数で置換 | E-02（373行目: replace (label_numberofvotes,"[NMBR]",total,1,-1,1)） | ○ |
| C-16 | フォームに12個の選択肢入力欄を表示 | E-01（28-29行目: for ip=1 to 12 ... <input type="text" ... name="sA<%=ip%>"...） | ○ |
| C-17 | 各選択肢にカラーピッカーを設置 | E-01（29-31行目: for ip=1 to 12 ... response.write JQColorPicker("sA" & ip & "c")） | ○ |
| C-18 | 使用箇所検索でcls_fullSearchを使用 | E-01（33-42行目: set fsearch=new cls_fullSearch ... fsearch.pattern="\[QS_POLL:+("&poll.sCode&")+[\]]" ... fsearch.search()） | ○ |
| C-19 | 削除・リセット時はconfirmダイアログで確認 | E-01（29行目: onclick="javascript:return confirm('<%=l("areyousure")%>');"） | ○ |
| C-20 | 機能Noは60で機能名は「投票作成・編集」 | E-03（60行目: "60","管理画面/投票","投票作成・編集"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 選択肢数の画面表示（12個）とデータベース（15個）の差異が問題にならないか確認
- [ ] 投票結果集計時のSELECT COUNT(*)クエリ（最大15回）のパフォーマンスを確認
- [ ] dResetDateによるリセット後の再投票許可ロジックが正しく機能するか確認
- [ ] 使用箇所検索の正規表現パターンが正しく動作するか確認
