---
generated_at: 2026-01-23 23:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：61-ゲストブック一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_gbList.asp` - ゲストブック一覧画面のメインソースコード
- E-02: `asp/includes/guestbook.asp` - cls_guestbookクラス定義
- E-03: `asp/includes/customer.asp` - customerクラスのguestbooksプロパティ（930-945行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（61番）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblGuestbookテーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ゲストブック一覧機能は管理画面で提供される | E-01（bs_gbList.asp）、E-04 | ○ |
| C-02 | bGuestbook権限によるアクセス制御 | E-01 4行目「logon.hasaccess secondAdmin.bGuestbook」 | ○ |
| C-03 | customer.guestbooksでゲストブック一覧を取得 | E-01 8-9行目、E-03 930-945行目 | ○ |
| C-04 | ゲストブックのコピー機能がある | E-01 5-7行目、E-02 152-158行目 copy()メソッド | ○ |
| C-05 | コピー時はGeneratePasswordで新コード生成 | E-02 155行目「sCode=GeneratePassWord」 | ○ |
| C-06 | 編集画面へのリンク生成 | E-01 10行目「bs_gbEdit.asp」リンク | ○ |
| C-07 | 投稿管理画面へのリンク生成 | E-01 10行目「bs_gbEditItems.asp」リンク | ○ |
| C-08 | Excelエクスポートリンク生成 | E-01 10行目「bs_gbExcel.asp」リンク | ○ |
| C-09 | 埋め込みコード[QS_GUESTBOOK:コード名]の表示 | E-01 10行目「[QS_GUESTBOOK:」表示部分 | ○ |
| C-10 | iGBIDパラメータは暗号化される | E-01 7行目「encrypt(copyGB.iId)」、10行目「encrypt(gbKey)」 | ○ |
| C-11 | tblGuestbookテーブルからデータ取得 | E-02 48行目、E-03 935行目、E-06 | ○ |
| C-12 | 顧客IDでフィルタ | E-02 48行目「iCustomerID="&cid」、E-03 935行目 | ○ |
| C-13 | sCodeでソート | E-03 935行目「order by sCode」 | ○ |
| C-14 | JavaScript確認ダイアログ | E-01 10行目「confirm」 | ○ |
| C-15 | sanitize関数による出力サニタイズ | E-01 10行目「sanitize(guestbooks(gbKey).sCode)」 | ○ |
| C-16 | ゲストブックがない場合のメッセージ表示 | E-01 10行目「l("noguestbooks")」 | ○ |
| C-17 | 新規作成リンクの表示 | E-01 9行目「getArtLink("bs_gbEdit.asp",l("newguestbook")」 | ○ |
| C-18 | QS_secCodeURLによるCSRF対策 | E-01 10行目「QS_secCodeURL」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] 権限制御（bGuestbook）の実装確認
- [x] コピー機能の実装確認
- [x] 一覧取得処理の実装確認
- [x] セキュリティ対策（CSRF、暗号化、サニタイズ）の確認
- [ ] 本番環境での動作確認
