---
generated_at: 2026-01-23 23:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-ゲストブック作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_gbEdit.asp` - ゲストブック編集画面のメインソースコード
- E-02: `asp/includes/guestbook.asp` - cls_guestbookクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（62番）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblGuestbookテーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bGuestbook権限によるアクセス制御 | E-01 4行目「logon.hasaccess secondAdmin.bGuestbook」 | ○ |
| C-02 | sCode、sNameが必須項目 | E-02 71-82行目 check()メソッド | ○ |
| C-03 | sCodeは小文字変換して取得 | E-02 127行目「lcase(convertStr(Request.Form ("sCode")))」 | ○ |
| C-04 | sCodeは大文字でDB保存 | E-02 101行目「rs("sCode") = ucase(sCode)」 | ○ |
| C-05 | CSRFチェック実装 | E-01 13行目「checkCSRF()」 | ○ |
| C-06 | 保存成功時は一覧へリダイレクト | E-01 16行目「Response.Redirect ("bs_gbList.asp")」 | ○ |
| C-07 | 削除時も一覧へリダイレクト | E-01 21行目「Response.Redirect ("bs_gbList.asp")」 | ○ |
| C-08 | 削除時に関連投稿を先に削除 | E-02 146行目「delete from tblGuestbookItem」 | ○ |
| C-09 | デフォルトテンプレートが設定される | E-02 25-30行目 Class_Initializeでテンプレート初期化 | ○ |
| C-10 | 通知メール初期値はwebmasterEmail | E-02 24行目「sEmail=customer.webmasterEmail」 | ○ |
| C-11 | iPagingのデフォルト値は10 | E-02 21行目「iPaging=10」 | ○ |
| C-12 | bRequireValidationのデフォルトはtrue | E-02 23行目「bRequireValidation=true」 | ○ |
| C-13 | postBackフラグの判定 | E-01 7行目「postBack=convertBool(Request.Form("postBack"))」 | ○ |
| C-14 | getRequestValues()で入力値取得 | E-01 9行目、14行目「guestbook.getRequestValues()」 | ○ |
| C-15 | save()メソッドで保存処理 | E-01 15行目「guestbook.save」 | ○ |
| C-16 | remove()メソッドで削除処理 | E-01 20行目「guestbook.remove」 | ○ |
| C-17 | ADO Recordsetで保存 | E-02 94行目「set rs = db.GetDynamicRS」 | ○ |
| C-18 | 新規時はAddNew、既存時は条件SELECT | E-02 95-100行目 分岐処理 | ○ |
| C-19 | 使用箇所検索機能 | E-01 27-35行目 cls_fullSearch使用 | ○ |
| C-20 | 正規表現パターンで検索 | E-01 29行目「fsearch.pattern="\[QS_GUESTBOOK:+("&guestbook.sCode&")+[\]]"」 | ○ |
| C-21 | quotRep関数でエスケープ | E-01 22行目以降のフォーム値表示「quotRep(guestbook.sName)」 | ○ |
| C-22 | JavaScript確認ダイアログ | E-01 25行目「confirm('<%=l("areyousure")%>')」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] 必須項目バリデーションの実装確認
- [x] CSRF対策の実装確認
- [x] 削除時の連動削除処理確認
- [x] テンプレートプレースホルダーの仕様確認
- [ ] 本番環境での動作確認
