---
generated_at: 2026-01-23 23:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-ゲストブック投稿管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_gbEditItems.asp` - 投稿管理画面のメインソースコード
- E-02: `asp/includes/guestbook.asp` - cls_guestbookクラス（entries()メソッド）
- E-03: `asp/includes/guestbookitem.asp` - cls_guestbookitemクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（63番）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblGuestbookItemテーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bGuestbook権限によるアクセス制御 | E-01 4行目「logon.hasaccess secondAdmin.bGuestbook」 | ○ |
| C-02 | CSRFチェック実装 | E-01 9行目「checkCSRF()」 | ○ |
| C-03 | 複数投稿を一括処理 | E-01 10行目「for each entryID in Request.Form ("iGBItemID")」 | ○ |
| C-04 | cls_guestbookitemで投稿データ操作 | E-01 11行目「set entry=new cls_guestbookitem」 | ○ |
| C-05 | pick()でデータ読込 | E-01 12行目「entry.pick(entryID)」 | ○ |
| C-06 | 削除フラグで分岐 | E-01 18-22行目「if convertBool(Request.Form ("remove" & entryID))」 | ○ |
| C-07 | 削除時はremove()実行 | E-01 19行目「entry.remove()」 | ○ |
| C-08 | 更新時はsave()実行 | E-01 21行目「entry.save()」 | ○ |
| C-09 | 保存完了メッセージ表示 | E-01 26行目「Message.Add("fb_saveOK")」 | ○ |
| C-10 | entries()でDictionary取得 | E-01 28行目「set entries=guestbook.entries」、E-02 285-302行目 | ○ |
| C-11 | 降順表示（dCreatedTS desc） | E-02 288行目「order by dCreatedTS desc」 | ○ |
| C-12 | QS_VBScriptIdentifier区切り | E-02 298行目 entries.Add | ○ |
| C-13 | sanitize関数でサニタイズ | E-01 30行目「sanitize(arrE(3))」など | ○ |
| C-14 | 投稿者メールのmailtoリンク | E-01 30行目「<a href="mailto:<%=sanitize(arrE(5))%>">」 | ○ |
| C-15 | sValueの最大5000文字 | E-03 126行目「rs("sValue") = left(sValue,5000)」 | ○ |
| C-16 | sMessageByの最大50文字 | E-03 127行目「rs("sMessageBy") = left(sMessageBy,50)」 | ○ |
| C-17 | ページキャッシュクリア | E-03 137行目「selectedPage.clearPageCache()」 | ○ |
| C-18 | tblGuestbookItemテーブル操作 | E-03 98行目、124行目、142行目、E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] ループ処理による一括更新の実装確認
- [x] 削除/更新の分岐処理確認
- [x] CSRF対策の実装確認
- [x] サニタイズ処理の確認
- [ ] 本番環境での動作確認
