---
generated_at: 2026-01-23 23:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-ポップアップ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_popupList.asp` - ポップアップ一覧画面のメインソースコード
- E-02: `asp/includes/popup.asp` - cls_popupクラス定義
- E-03: `asp/includes/customer.asp` - customerクラスのpopupsプロパティ（871-886行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（65番）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblPopupテーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ポップアップ一覧機能は管理画面で提供される | E-01（bs_popupList.asp）、E-04 | ○ |
| C-02 | bPopup権限によるアクセス制御 | E-01 4行目「logon.hasaccess secondAdmin.bPopup」 | ○ |
| C-03 | customer.popupsでポップアップ一覧を取得 | E-01 14-15行目、E-03 871-886行目 | ○ |
| C-04 | ポップアップのコピー機能がある | E-01 5-7行目、E-02 187-192行目 copy()メソッド | ○ |
| C-05 | コピー成功時は編集画面へリダイレクト | E-01 7行目「Response.Redirect ("bs_popupEdit.asp?ipopupID=")」 | ○ |
| C-06 | 表示回数リセット機能 | E-01 8-12行目「copyPopup.iShows=0」「copyPopup.save()」 | ○ |
| C-07 | 編集画面へのリンク生成 | E-01 16行目「bs_popupEdit.asp」リンク | ○ |
| C-08 | プレビュー機能（window.open） | E-01 16行目「window.open」「forcePP=」 | ○ |
| C-09 | IDパラメータは暗号化される | E-01 7行目「encrypt(copypopup.iId)」、16行目「encrypt(popupkey)」 | ○ |
| C-10 | tblPopupテーブルからデータ取得 | E-02 112行目、E-03 876行目、E-06 | ○ |
| C-11 | 顧客IDでフィルタ | E-02 112行目「iCustomerID="&cid」、E-03 876行目 | ○ |
| C-12 | sNameでソート | E-03 876行目「order by sName」 | ○ |
| C-13 | JavaScript確認ダイアログ | E-01 16行目「confirm」 | ○ |
| C-14 | 有効時は太字「Enabled」表示 | E-01 16行目「<strong>Enabled</strong>」 | ○ |
| C-15 | 無効時はグレー「Disabled」表示 | E-01 16行目「<font color=#AAA>Disabled</font>」 | ○ |
| C-16 | 表示回数（iShows）の表示 | E-01 16行目「popups(popupkey).iShows」 | ○ |
| C-17 | ポップアップがない場合のメッセージ表示 | E-01 16行目「No Popups available」 | ○ |
| C-18 | 新規作成リンクの表示 | E-01 15行目「New Popup」リンク | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] 権限制御（bPopup）の実装確認
- [x] コピー機能の実装確認
- [x] リセット機能の実装確認
- [x] プレビュー機能の実装確認
- [ ] 本番環境での動作確認
