---
generated_at: 2026-01-23 23:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-ポップアップ作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_popupEdit.asp` - ポップアップ編集画面のメインソースコード
- E-02: `asp/includes/popup.asp` - cls_popupクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（66番）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblPopupテーブル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bPopup権限によるアクセス制御 | E-01 4行目「logon.hasaccess secondAdmin.bpopup」 | ○ |
| C-02 | bNOPopup=trueでポップアップ表示抑制 | E-01 4行目「bNOPopup=true」 | ○ |
| C-03 | sNameが必須項目 | E-02 135-137行目 check()メソッド「if isLeeg(sName)」 | ○ |
| C-04 | sUrlまたはsValueが必須 | E-02 139-142行目「if isLeeg(sUrl) and isLeeg(sValue)」 | ○ |
| C-05 | CSRFチェック実装 | E-01 15行目「checkCSRF()」 | ○ |
| C-06 | 保存成功時は一覧へリダイレクト | E-01 17行目「Response.Redirect ("bs_popupList.asp")」 | ○ |
| C-07 | 削除時も一覧へリダイレクト | E-01 11行目「Response.Redirect ("bs_popupList.asp")」 | ○ |
| C-08 | デフォルト幅は400px | E-02 12行目「iWidth=400」 | ○ |
| C-09 | デフォルト高さは300px | E-02 11行目「iHeight=300」 | ○ |
| C-10 | デフォルトURLは"http://" | E-02 13行目「sUrl="http://"」 | ○ |
| C-11 | postBackフラグの判定 | E-01 8行目「postBack=convertBool(Request.Form("postBack"))」 | ○ |
| C-12 | getRequestValues()で入力値取得 | E-01 14行目「popup.getRequestValues()」 | ○ |
| C-13 | save()メソッドで保存処理 | E-01 16行目「popup.save」 | ○ |
| C-14 | remove()メソッドで削除処理 | E-01 10行目「popup.remove」 | ○ |
| C-15 | ADO Recordsetで保存 | E-02 154行目「set rs = db.GetDynamicRS」 | ○ |
| C-16 | 新規時はAddNew、既存時は条件SELECT | E-02 155-160行目 分岐処理 | ○ |
| C-17 | iModeによる表示頻度制御 | E-02 36-93行目 bOnlineプロパティ | ○ |
| C-18 | iAutoclose自動閉じ機能 | E-02 103行目「iAutoclose」、203-205行目 setTimeout | ○ |
| C-19 | quotRep関数でエスケープ | E-01 19-21行目のフォーム値表示「quotRep(popup.sName)」 | ○ |
| C-20 | JavaScript確認ダイアログ | E-01 21行目「confirm('<%=l("areyousure")%>')」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] 必須項目バリデーションの実装確認
- [x] CSRF対策の実装確認
- [x] 表示モード制御の実装確認
- [x] 自動閉じ機能の実装確認
- [ ] 本番環境での動作確認
