---
generated_at: 2026-01-23 23:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-購読者管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_newsletterSubscribers.asp` - 購読者一覧画面のメインソースコード
- E-02: `asp/bs_newsletterSubscriber.asp` - 購読者編集画面のメインソースコード
- E-03: `asp/includes/newsletterSubscriber.asp` - cls_newsletterSubscriberクラス定義
- E-04: `asp/includes/newsletterCategory.asp` - cls_newsletterCategoryクラス定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（69番）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bNewsletter権限によるアクセス制御 | E-01 4行目、E-02 4行目「logon.hasaccess secondAdmin.bNewsletter」 | ○ |
| C-02 | カテゴリごとのフィルタリング | E-01 17行目「iCategoryID=convertGetal(decrypt(request(\"iCategoryID\")))」 | ○ |
| C-03 | 単一カテゴリ自動選択 | E-01 19-24行目「if NewsletterCategories.count=1」 | ○ |
| C-04 | 一括削除処理 | E-01 27-35行目「for each delID in request.form(\"deleteID\")」 | ○ |
| C-05 | tblNewsletterLog関連削除 | E-01 29-30行目、E-02 25行目「delete from tblNewsletterLog」 | ○ |
| C-06 | tblNewsletterCategorySubscriber削除 | E-01 32-33行目、E-02 26行目「delete from tblNewsletterCategorySubscriber」 | ○ |
| C-07 | 有効状態フィルタ（デフォルト有効） | E-01 37-44行目 select case、39行目「bActive=」デフォルト | ○ |
| C-08 | 名前検索機能 | E-01 47-48行目「sName like '%」 | ○ |
| C-09 | メール検索機能 | E-01 50-51行目「sEmail like '%」 | ○ |
| C-10 | 購読者数カウント | E-01 46行目「select count(*)」、76行目「Total: <strong><%=counter%>」 | ○ |
| C-11 | Proper Case処理 | E-01 56-67行目「if request.form (\"pcase\")=\"1\"」「PCase(convertStr(rs(\"sName\")))」 | ○ |
| C-12 | 一括配信解除処理 | E-01 78-95行目「if not isLeeg(request.form(\"unsubscribers\"))」 | ○ |
| C-13 | 解除時bActive=false | E-01 87-88行目「recordSET(\"bActive\")=false」 | ○ |
| C-14 | 最大2500件表示制限 | E-01 104行目「while not rs.eof and subCounter<2500」 | ○ |
| C-15 | 2500件超過警告 | E-01 118-119行目「if subCounter>2499」「alert('Warning!」 | ○ |
| C-16 | sNameでソート | E-01 75行目「order by sName」 | ○ |
| C-17 | 編集画面でのメール形式検証 | E-02 15行目「if not checkEmailSyntax(request.form(\"sEmail\"))」 | ○ |
| C-18 | 編集画面でのレコード存在チェック | E-02 9行目「if rs.recordcount=0 then response.redirect」 | ○ |
| C-19 | 編集画面での保存処理 | E-02 11-22行目「if request.form(\"btnaction\")=l(\"save\")」 | ○ |
| C-20 | 編集画面での削除処理 | E-02 24-27行目「if request.form(\"btnaction\")=l(\"delete\")」 | ○ |
| C-21 | JavaScript確認ダイアログ（一括削除） | E-01 102行目「confirm('Are you sure to delete」 | ○ |
| C-22 | JavaScript確認ダイアログ（一括解除） | E-01 128行目「confirm('Are you sure to unsubscribe」 | ○ |
| C-23 | JavaScript確認ダイアログ（編集削除） | E-02 28行目「confirm('Are you sure to delete this subscription?')」 | ○ |
| C-24 | quotRep関数でエスケープ | E-01 107-108行目、E-02 28行目「quotRep(rs(」 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対して根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる事項で構成されているため、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [x] 権限制御（bNewsletter）の実装確認
- [x] 一括削除機能の実装確認
- [x] 一括解除機能の実装確認
- [x] Proper Case機能の実装確認
- [x] 検索機能の実装確認
- [x] 表示上限制御の実装確認
- [x] メール形式検証の実装確認
- [ ] 本番環境での動作確認（大量データ時のパフォーマンス含む）
