---
generated_at: 2026-01-23 23:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-メーリング作成・送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **開封追跡の詳細な動作**：フロントエンド側のログ記録処理の確認が必要
  2. **メール送信クラスの詳細**：cls_mail_messageの詳細実装未確認
  3. **SMTP設定**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_newsletterMailingEdit.asp` 全体
- E-02: `asp/bs_newsletterMailingSend.asp` 全体
- E-03: `asp/includes/newsletterMailing.asp` 全体
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 71行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 69-79行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター購読者への一斉配信機能を提供 | E-02: 25-75行目の送信ループ | ○ |
| C-02 | secondAdmin.bNewsletter権限によるアクセス制御 | E-01: 4行目 `logon.hasaccess secondAdmin.bNewsletter` | ○ |
| C-03 | iNewsletterIDは必須パラメータ | E-03: 32-35行目 check関数 | ○ |
| C-04 | sCategoryは必須パラメータ | E-03: 36-39行目 check関数 | ○ |
| C-05 | プレビュー送信機能の存在 | E-01: 18-20行目 | ○ |
| C-06 | 重複送信防止機能 | E-02: 39行目 allEmails.existsチェック | ○ |
| C-07 | 段階的送信処理（バッチ処理） | E-02: 35-64行目 | ○ |
| C-08 | 開封追跡用画像URLの埋め込み | E-02: 51行目 sAddImageUrl生成 | ○ |
| C-09 | tblNewsletterMailingへのデータ保存 | E-03: 52-66行目 save関数 | ○ |
| C-10 | tblNewsletterLogへのログ記録 | E-02: 43-53行目 | ○ |
| C-11 | 送信完了時にdSentDate更新 | E-02: 68-69行目 | ○ |
| C-12 | bLog=falseの場合メーリング削除 | E-02: 90行目 newsletterMailing.remove() | ○ |
| C-13 | CSRF対策の実装 | E-01: 14行目 checkCSRF() | ○ |
| C-14 | IDパラメータの暗号化 | E-01, E-02: encrypt/decrypt関数使用 | ○ |
| C-15 | 送信間隔・件数の設定可能 | E-02: 12-17行目 iInterval, iIntervalS | ○ |
| C-16 | アクティブ購読者のみ送信 | E-02: 29行目 bActive=true条件 | ○ |
| C-17 | 関連画面との連携 | E-05: 画面49,50の存在確認 | ○ |
| C-18 | メール送信クラスの使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_mail_messageクラスの実装詳細
  - 候補：`asp/includes/mail.asp` / `asp/includes/email.asp` / 外部ライブラリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり
- 1: 中リスク - メール送信処理のエラーハンドリング詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] メール送信クラス（cls_mail_message）の実装を確認
- [ ] SMTP設定の適切性を確認
- [ ] 大量送信時のパフォーマンス・サーバー負荷を確認
- [ ] 開封追跡URLのセキュリティ（推測困難性）を確認
