---
generated_at: 2026-01-23 23:18:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-予約カレンダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac.asp` 全体
- E-02: `asp/bs_ac_calendar.asp` 全体
- E-03: `asp/includes/ac_calendar.asp` 全体
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 74行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 142-150行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 予約カレンダーの一覧表示機能 | E-03: mycals関数 | ○ |
| C-02 | secondAdmin.bAvailabilityCal権限によるアクセス制御 | E-01: 4行目 | ○ |
| C-03 | sNameは必須パラメータ | E-03: check関数 | ○ |
| C-04 | カスケード削除（予約も削除） | E-03: delete関数 | ○ |
| C-05 | calActionによる画面分岐 | E-01: 8-9行目 select case | ○ |
| C-06 | 新規カレンダー作成機能 | E-02: save処理 | ○ |
| C-07 | カレンダー名編集機能 | E-02: 7行目 sName設定 | ○ |
| C-08 | カレンダー削除機能 | E-02: 12-13行目 | ○ |
| C-09 | 顧客IDによるデータ分離 | E-03: secure=true, iCustomerID条件 | ○ |
| C-10 | 作成日時の記録 | E-03: dCreatedTS設定 | ○ |
| C-11 | 削除確認ダイアログ | E-02: 15行目 onclick confirm | ○ |
| C-12 | 関連画面との連携 | E-05: 画面105,108-112の存在確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] カスケード削除時のデータ整合性を確認
- [ ] 複数顧客間でのカレンダーデータ分離が正しく動作することを確認
- [ ] カレンダービューの表示が正しいことを確認
