---
generated_at: 2026-01-23 23:19:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-カレンダー予約管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_booking.asp` 全体
- E-02: `asp/bs_ac_bookings.asp` 全体
- E-03: `asp/includes/ac_calendarbooking.asp` 全体
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 75行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 143-144行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 予約一覧表示機能 | E-02: 5行目 bookings取得 | ○ |
| C-02 | 予約の新規登録機能 | E-01, E-03: save関数 | ○ |
| C-03 | 予約の編集機能 | E-01: 15-17行目、E-03: save関数 | ○ |
| C-04 | 予約の削除機能 | E-01: 19-21行目、E-03: delete関数 | ○ |
| C-05 | sNameは必須パラメータ | E-03: 45-48行目 check関数 | ○ |
| C-06 | dStartDateは必須パラメータ | E-03: 49-52行目 | ○ |
| C-07 | dEndDateは必須パラメータ | E-03: 53-56行目 | ○ |
| C-08 | 終了日>=開始日のバリデーション | E-03: 57-59行目 | ○ |
| C-09 | 重複予約チェック機能 | E-03: 61-95行目 | ○ |
| C-10 | 半日対応（午後のみ/午前のみ） | E-03: 78-89行目 bSOnlyAfternoon, bEOnlyMorning判定 | ○ |
| C-11 | DatePicker使用 | E-01: 26行目 JQDatePickerFT呼び出し | ○ |
| C-12 | WYSIWYGエディタ使用 | E-01: 26行目 createFCKInstance呼び出し | ○ |
| C-13 | 削除確認ダイアログ | E-01: 26行目 onclick confirm | ○ |
| C-14 | 予約一覧のソート機能 | E-02: 6行目 sortable class | ○ |
| C-15 | 関連画面との連携 | E-05: 画面106,107の存在確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 重複チェックロジックのエッジケース（同日チェックイン・チェックアウト）を確認
- [ ] 半日対応のフラグが正しく機能することを確認
- [ ] 大量の予約がある場合のパフォーマンスを確認
