---
generated_at: 2026-01-23 23:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-カレンダー埋め込みコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_embed.asp` 全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 76行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 148行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JavaScript埋め込みコード生成機能 | E-01: 31行目 embedJSCode | ○ |
| C-02 | iframe埋め込みコード生成機能 | E-01: 32行目 embedIFcode | ○ |
| C-03 | リンクURL生成機能 | E-01: 33行目 embedHTMLcode | ○ |
| C-04 | 期間タイプ選択（月数指定/今年/来年） | E-01: 33行目 time=0/1/2 | ○ |
| C-05 | 月数選択機能 | E-01: 34行目 months select | ○ |
| C-06 | 凡例表示フラグ | E-01: 4-13行目 iLegend | ○ |
| C-07 | デフォルト月数12ヶ月 | E-01: 18-19行目 nm="12" | ○ |
| C-08 | 凡例デフォルト有効 | E-01: 11-12行目 iLegend=" checked " | ○ |
| C-09 | textareaでコード表示 | E-01: 35行目 textarea onclick select | ○ |
| C-10 | クリックで全選択 | E-01: 35行目 onclick="javascript:this.select();" | ○ |
| C-11 | 関連画面との連携 | E-03: 画面111の存在確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されるURLが正しく動作することを確認
- [ ] 外部サイトからの埋め込みが正しく表示されることを確認
- [ ] 異なるブラウザでの互換性を確認
