---
generated_at: 2026-01-23 23:21:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-ショッピングカート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_shoppingcart.asp` 全体
- E-02: `asp/includes/shopCategory.asp` 全体
- E-03: `asp/includes/shopProduct.asp` 全体
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 77行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 135行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カテゴリ一覧表示（階層構造） | E-01: 8-20行目、E-02: list, subcategories | ○ |
| C-02 | メーカー一覧表示 | E-01: 21-25行目 | ○ |
| C-03 | 商品一覧表示 | E-01: 30-44行目 | ○ |
| C-04 | secondAdmin.bShoppingCart権限 | E-01: 4行目 | ○ |
| C-05 | オフライン状態の色分け表示 | E-01: 10行目 MYQS_offlineLinkColor | ○ |
| C-06 | 名前順ソート | E-02: 27行目 order by sName、E-03: 11行目 | ○ |
| C-07 | 商品編集リンク | E-01: 39行目 bs_shopProduct.asp | ○ |
| C-08 | カテゴリ設定リンク | E-01: 40行目 bs_shopProductCat.asp | ○ |
| C-09 | 画像管理リンク | E-01: 41行目 bs_shopProductImg.asp | ○ |
| C-10 | 新規カテゴリ追加ボタン | E-01: 20行目 Add Category | ○ |
| C-11 | 新規メーカー追加ボタン | E-01: 25行目 Add Make | ○ |
| C-12 | 新規商品追加ボタン | E-01: 44行目 Add Product | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 大量の商品・カテゴリがある場合のパフォーマンスを確認
- [ ] 階層構造の表示が正しいことを確認
- [ ] オンライン/オフライン状態の色分けが適切であることを確認
