---
generated_at: 2026-01-23 23:22:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-商品管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_shopProduct.asp` 全体
- E-02: `asp/includes/shopProduct.asp` 全体
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 78行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 138行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品情報の新規登録機能 | E-02: 50-82行目 save関数 | ○ |
| C-02 | 商品情報の編集機能 | E-01: 14-20行目 | ○ |
| C-03 | 商品の削除機能 | E-01: 21-23行目、E-02: 83-90行目 | ○ |
| C-04 | sNameは必須パラメータ | E-02: 37-41行目 check関数 | ○ |
| C-05 | iStockは数値チェック | E-02: 42-48行目 | ○ |
| C-06 | secondAdmin.bShoppingCart権限 | E-01: 4行目 | ○ |
| C-07 | 削除時に画像フォルダも削除 | E-02: 84-88行目 fso.deleteFolder | ○ |
| C-08 | WYSIWYGエディタ使用 | E-01: 25行目 createFCKInstance | ○ |
| C-09 | メーカー選択機能 | E-01: 25行目 showMake | ○ |
| C-10 | 入力値サニタイズ | E-01: 25行目 sanitize関数 | ○ |
| C-11 | CSRF対策 | E-01: 25行目 QS_secCodeHidden | ○ |
| C-12 | IDパラメータ暗号化 | E-01: encrypt/decrypt使用 | ○ |
| C-13 | タイムスタンプ記録 | E-02: 62, 75行目 dCreatedTS, dUpdatedTS | ○ |
| C-14 | 削除確認ダイアログ | E-01: 25行目 onclick confirm | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ファイルシステム操作の権限が適切であることを確認
- [ ] 削除時のカスケード削除（カテゴリ関連、画像）が正しく動作することを確認
- [ ] WYSIWYGエディタのXSS対策を確認
