---
generated_at: 2026-01-23 23:23:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-商品カテゴリ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_shopAdCat.asp` 全体
- E-02: `asp/bs_shopProductCat.asp` 全体
- E-03: `asp/includes/shopCategory.asp` 全体
- E-04: `asp/includes/shopProduct.asp` 134-143行目（saveCats関数）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 79行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 136, 139行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カテゴリの新規作成機能 | E-03: 61-90行目 save関数 | ○ |
| C-02 | カテゴリの編集機能 | E-01: 11-15行目 | ○ |
| C-03 | カテゴリの削除機能 | E-01: 16-18行目、E-03: 91-95行目 | ○ |
| C-04 | sNameは必須パラメータ | E-03: 53-59行目 check関数 | ○ |
| C-05 | secondAdmin.bShoppingCart権限 | E-01, E-02: 4行目 | ○ |
| C-06 | 階層制限（2階層まで） | E-03: 96-105行目 bShowParentCatDropDown | ○ |
| C-07 | オフライン連動 | E-03: 87-89行目 | ○ |
| C-08 | 削除時の子参照解除 | E-03: 92行目 iParentCatID=null | ○ |
| C-09 | 削除時の商品関連削除 | E-03: 93行目 tblQShopProdCat DELETE | ○ |
| C-10 | 商品カテゴリ割り当て機能 | E-02: 10-12行目、E-04 | ○ |
| C-11 | 複数カテゴリ割り当て可能 | E-02: 16行目 チェックボックス | ○ |
| C-12 | 全削除後に新規登録 | E-04: 135-142行目 | ○ |
| C-13 | CSRF対策 | E-01, E-02: QS_secCodeHidden | ○ |
| C-14 | IDパラメータ暗号化 | E-01, E-02: encrypt/decrypt使用 | ○ |
| C-15 | 入力値サニタイズ | E-01, E-02: sanitize関数 | ○ |
| C-16 | 関連画面との連携 | E-06: 画面99,102の存在確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 階層制限（2階層）が正しく動作することを確認
- [ ] オフライン連動が子カテゴリに正しく伝播することを確認
- [ ] 商品カテゴリ割り当ての全削除→再登録のトランザクションを確認
