---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ページ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_default.asp` - ページ一覧画面（16行）
- E-02: `asp/bs_menu.asp` - メニュー表示処理（27行）
- E-03: `asp/bs_process.asp` - アクション処理（214行）
- E-04: `asp/includes/menu.asp` - cls_menuクラス（200行以上）
- E-05: `asp/includes/page.asp` - cls_pageクラス（300行以上）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_security.aspで認証チェック | E-01（3行目: bs_security.aspインクルード） | ○ |
| C-02 | bs_menu.aspでメニュー表示 | E-01（4行目: bs_menu.aspインクルード） | ○ |
| C-03 | 新規ページリンクにbPagesAdd権限チェック | E-01（4行目: if secondAdmin.bPagesAdd） | ○ |
| C-04 | キャッシュ利用でメニュー表示 | E-02（4-6行目: application(QS_CMS_cacheBOMenu)） | ○ |
| C-05 | getBOMenuでメニュー生成 | E-02（5行目: menu.getBOMenu(null,false)） | ○ |
| C-06 | lossePaginasでフリーページ取得 | E-02（8-9行目: menu.lossePaginas(false)） | ○ |
| C-07 | MoveUpでCSRF検証 | E-03（21行目: checkCSRF） | ○ |
| C-08 | MoveDownでCSRF検証 | E-03（29行目: checkCSRF） | ○ |
| C-09 | CopyでCSRF検証 | E-03（66行目: checkCSRF） | ○ |
| C-10 | page.moveUp()で表示順上げ | E-03（22行目: page.moveUp()） | ○ |
| C-11 | page.moveDown()で表示順下げ | E-03（30行目: page.moveDown()） | ○ |
| C-12 | page.copy()でページコピー | E-03（67-68行目: page.bCopy=true, page.copy()） | ○ |
| C-13 | 権限別アイコン表示（bPagesAdd） | E-04（182-183行目: if secondAdmin.bPagesAdd） | ○ |
| C-14 | 権限別アイコン表示（bPagesMove） | E-04（185-188行目: if secondAdmin.bPagesMove） | ○ |
| C-15 | 権限別アイコン表示（bPagesPW） | E-04（192-197行目: if secondAdmin.bPagesPW） | ○ |
| C-16 | iRangで表示順序 | E-04（163行目: order by iRang asc） | ○ |
| C-17 | bDeleted=falseで削除済み除外 | E-04（156行目: bDeleted=getSQLBoolean(false)） | ○ |
| C-18 | bLossePagina=falseでメニューページ取得 | E-04（156行目: bLossePagina=getSQLBoolean(false)） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ページ一覧表示処理が全てソースコードで確認済み
- 0: 低リスク - 権限チェックロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュが正しく機能し、ページ更新時にクリアされるか確認
- [ ] 権限に応じたアイコン表示が正しく動作するか確認
- [ ] フリーページが正しく別セクションに表示されるか確認
- [ ] ページ移動・コピー後のリダイレクトが適切か確認
