---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-メーカー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **メーカー削除時の商品データへの影響**：コード上で確認できず要検証
  2. **パフォーマンス要件**：明示的な記載なし
  3. **トランザクション制御の詳細**：ADO自動コミットの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shopMake.asp` - メーカー編集画面のASPファイル
- E-02: `asp/includes/shopMake.asp` - cls_shopMakeクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.81の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メーカー管理はショッピングカート機能の一部 | E-01（4行目: bShoppingCart権限チェック）, E-03 | ○ |
| C-02 | メーカー名は必須入力 | E-02（41-45行目: Check関数でsName空チェック） | ○ |
| C-03 | ロゴURLは任意入力 | E-01（20行目: フォームにrequired属性なし） | ○ |
| C-04 | 公開/非公開状態の設定が可能 | E-02（3行目: bOnlineプロパティ, 64行目: 保存処理） | ○ |
| C-05 | 権限チェックはsecondAdmin.bShoppingCart | E-01（4行目: logon.hasaccess secondAdmin.bShoppingCart） | ○ |
| C-06 | メーカーIDは暗号化される | E-01（6行目: decrypt(request("iShopMakeID"))) | ○ |
| C-07 | DBテーブルはtblQShopMake | E-02（26, 57, 61, 75行目: SQL文で確認） | ○ |
| C-08 | 保存後はbs_shoppingcart.aspへリダイレクト | E-01（15, 18行目: response.redirect） | ○ |
| C-09 | 削除はDELETE文で物理削除 | E-02（75行目: delete from tblQShopMake） | ○ |
| C-10 | 顧客ID（iCustomerID）で絞り込み | E-02（13, 67, 79行目: iCustomerID = cId） | ○ |
| C-11 | 作成日時はdCreatedTS | E-02（59行目: rs("dCreatedTS") = now()） | ○ |
| C-12 | 更新日時はdUpdatedTS | E-02（66行目: rs("dUpdatedTS") = now()） | ○ |
| C-13 | 文字数制限は255文字 | E-02（63, 65行目: left(xxx,255)） | ○ |
| C-14 | 入力サニタイズはsanitize関数使用 | E-01（20行目: sanitize(shopMake.sName)） | ○ |
| C-15 | CSRF対策はQS_secCodeHiddenで実装 | E-01（20行目: <%=QS_secCodeHidden%>） | ○ |
| C-16 | 一覧取得時はsNameでソート | E-02（13行目: order by sName） | ○ |
| C-17 | 削除確認のconfirmダイアログ表示 | E-01（20行目: onclick="javascript:return confirm"） | ○ |
| C-18 | 削除時の商品データへの影響考慮 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 削除時の商品データへの影響
  - 候補：bs_shopProduct.asp / 商品テーブルの外部キー制約 / カスケード削除設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD機能であり、ソースコードとの整合性が高い
- 1: 中リスク - 削除時のデータ整合性（商品との関連）が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] メーカー削除時に関連する商品データがどうなるか確認する
- [ ] tblQShopMakeテーブルの外部キー制約を確認する
- [ ] 権限設定（bShoppingCart）の付与対象を確認する
