---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：82-イントラネット管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **customerオブジェクトの保存処理詳細**：customer.aspの確認が必要
  2. **必須チェックのバリデーション詳細**：customer.save()内の実装確認
  3. **データベーステーブル構造**：tblCustomerの正確なカラム名確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_adminIntranet.asp` - イントラネット管理画面のASPファイル
- E-02: `asp/bs_intranet.asp` - イントラネットページ一覧画面
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.82の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イントラネット管理は会員限定エリアの設定機能 | E-01, E-03 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetSetup | E-01（4行目: logon.hasaccess secondAdmin.bIntranetSetup） | ○ |
| C-03 | イントラネット有効/無効の切り替えが可能 | E-01（16行目: intranetUseチェックボックス） | ○ |
| C-04 | ログインモードはメール/ニックネーム選択 | E-01（16行目: iLoginModeセレクト、0=メール、1=ニックネーム） | ○ |
| C-05 | プロフィール機能の有効/無効設定が可能 | E-01（16行目: intranetUseMyProfileチェックボックス） | ○ |
| C-06 | アバター機能の設定が可能 | E-01（16-17行目: bUseAvatars, iAvatarSize, sAvatarBorderColor） | ○ |
| C-07 | アバターサイズはデフォルト80px | E-01（17行目: if iAvatarSize=0 then iAvatarSize=80） | ○ |
| C-08 | アバターサイズは32-150pxの範囲 | E-01（17行目: numberList(32,150,1,customer.iAvatarSize)） | ○ |
| C-09 | 新規登録許可/禁止の設定が可能 | E-01（17行目: bAllowNewRegistrationsチェックボックス） | ○ |
| C-10 | デフォルト会員ステータスの設定が可能 | E-01（17行目: iDefaultStatusセレクト） | ○ |
| C-11 | 新規会員通知メール設定が可能 | E-01（17行目: bSendMailUponNewMember, sEmailNewRegistrations） | ○ |
| C-12 | サイレントステータスは選択肢から除外 | E-01（4行目: cslist.list.remove(cs_silent)） | ○ |
| C-13 | CSRF対策はcheckCSRF()で実装 | E-01（11行目: checkCSRF()） | ○ |
| C-14 | 保存成功時はfb_saveOKメッセージ表示 | E-01（14行目: message.Add("fb_saveOK")） | ○ |
| C-15 | 保存前に確認ダイアログ表示 | E-01（16行目: onsubmit="javascript:return confirm"） | ○ |
| C-16 | 設定変更時に画面が動的再表示 | E-01（16行目: onclick="javascript:document.mainform.submit();"） | ○ |
| C-17 | オンスクリーンメッセージ設定は別画面 | E-01（16行目: href="bs_adminIntranetOSM.asp"） | ○ |
| C-18 | 自動メール設定は別画面 | E-01（16行目: href="bs_adminIntranetEM.asp"） | ○ |
| C-19 | イントラネットページ一覧は権限bIntranet | E-02（4行目: logon.hasaccess secondAdmin.bIntranet） | ○ |
| C-20 | データベースはcustomer.save()で保存 | **根拠なし（customer.aspの確認が必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- customer.save()メソッドの実装詳細
  - 候補：asp/includes/customer.asp / tblCustomerテーブル定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定画面であり、ソースコードとの整合性が高い
- 1: 中リスク - customerオブジェクトの保存処理詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] customer.aspのsave()メソッドでイントラネット設定が正しく保存されるか確認
- [ ] tblCustomerテーブルのカラム名と設計書の項目名が一致するか確認
- [ ] 各設定の必須チェックロジックを確認する
