---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：83-コンタクト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **cls_contactSearchの詳細実装**：contactSearch.aspの確認が必要
  2. **Excel出力の実装詳細**：出力形式の確認
  3. **ページネーション実装**：大量データ時の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_contactHome.asp` - コンタクト一覧画面のASPファイル
- E-02: `asp/includes/contact.asp` - cls_contactクラス定義
- E-03: `asp/includes/contactField.asp` - cls_contactFieldクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.83の定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンタクト一覧は会員情報の検索・一覧表示機能 | E-01, E-04 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetContacts | E-01（4行目: logon.hasaccess secondAdmin.bIntranetContacts） | ○ |
| C-03 | カスタムフィールドで検索条件が動的生成 | E-01（5-8行目: customer.contactFields取得、23-24行目: フィールドタイプ別フォーム） | ○ |
| C-04 | メールアドレス検索が可能 | E-01（26行目: sEmailフィールド） | ○ |
| C-05 | ニックネーム検索が可能 | E-01（26行目: sNicknameフィールド） | ○ |
| C-06 | 会員ステータスで絞り込み可能 | E-01（26行目: iStatusセレクト、cslist.showSelected） | ○ |
| C-07 | 日付範囲検索が可能 | E-01（24-25行目: from/untillフィールド、JQDatePicker） | ○ |
| C-08 | ページサイズ選択が可能 | E-01（26行目: pageSizeセレクト、numberList(100,500,100)） | ○ |
| C-09 | 大量データ時のみページサイズ表示 | E-01（26行目: if customer.hasManyContacts then） | ○ |
| C-10 | 検索とExcelエクスポートの分岐 | E-01（26-27行目: select case contactSearch.mode） | ○ |
| C-11 | 一括メールは別権限が必要 | E-01（27行目: if secondAdmin.bIntranetMail then） | ○ |
| C-12 | 一括メール前に確認ダイアログ表示 | E-01（27行目: confirm('areyousure')） | ○ |
| C-13 | 一括メール時に警告表示 | E-01（27行目: warningcontacts） | ○ |
| C-14 | ポップアップで会員編集画面表示 | E-01（27-30行目: colorbox使用、bs_contactEdit.asp） | ○ |
| C-15 | ID暗号化はencrypt関数使用 | E-01（27行目: encrypt(contact.iId)、encrypt(request.querystring("iCPP"))） | ○ |
| C-16 | カスタムフィールドはDictionaryで保持 | E-02（9行目: set fields=server.CreateObject("scripting.dictionary")） | ○ |
| C-17 | 会員削除時に関連データも削除 | E-02（247-271行目: tblContactValues, tblTheme関連等の削除） | ○ |
| C-18 | cls_contactSearchのresultTable詳細 | **根拠なし（contactSearch.aspの確認が必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_contactSearchのresultTableメソッドの実装詳細
  - 候補：asp/includes/contactSearch.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 検索・一覧表示機能であり、基本的な処理フロー
- 1: 中リスク - 大量データ時のパフォーマンスを実際に確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] contactSearch.aspのresultTableメソッドを確認する
- [ ] Excel出力の実装と形式を確認する
- [ ] 大量会員データでのページネーション動作を確認する
