---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：84-コンタクト作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パスワード平文保存のセキュリティリスク**：要改善箇所
  2. **ステータス変更通知メールの内容定義**：cls_customerImessの確認
  3. **トランザクション不完全性**：フィールド値保存時のエラー処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_contactEdit.asp` - 会員編集画面のASPファイル
- E-02: `asp/includes/contact.asp` - cls_contactクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.84の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 会員作成・編集は会員情報のCRUD機能 | E-01, E-03 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetContacts | E-01（4行目: logon.hasaccess secondAdmin.bIntranetContacts） | ○ |
| C-03 | メールアドレスは必須かつ形式チェック | E-02（94-102行目: isLeeg, CheckEmailSyntax） | ○ |
| C-04 | パスワードは必須 | E-02（103-106行目: isLeeg(sPw)） | ○ |
| C-05 | ニックネームは必須 | E-02（107-110行目: isLeeg(sNickName)） | ○ |
| C-06 | メール重複チェックあり | E-02（114-120行目: select where sEmail） | ○ |
| C-07 | ニックネーム重複チェックあり | E-02（121-127行目: select where sNickName） | ○ |
| C-08 | 必須カスタムフィールドのチェック | E-02（86-93行目: bMandatoryループチェック） | ○ |
| C-09 | CSRF対策はcheckCSRF()で実装 | E-01（21, 28, 32行目: checkCSRF()） | ○ |
| C-10 | 保存成功時はfb_saveOKメッセージ | E-01（25, 37行目: message.Add("fb_saveOK")） | ○ |
| C-11 | 削除時はcPopup.close()で閉じる | E-01（30行目: cPopup.close()） | ○ |
| C-12 | パスワードリセット機能あり | E-01（31-39行目: savAndResetPw処理）, E-02（288-306行目: resetPW） | ○ |
| C-13 | パスワードリセット時にメール送信 | E-02（293-305行目: cls_mail_message使用） | ○ |
| C-14 | ステータス変更時に通知メール送信 | E-02（211-224行目: copyStatus<>iStatus判定、cls_mail_message） | ○ |
| C-15 | フィールド値は一度削除して再登録 | E-02（186-199行目: delete→AddNew） | ○ |
| C-16 | 会員削除時に関連データも削除 | E-02（247-270行目: tblContactValues, tblTheme関連等） | ○ |
| C-17 | パスワードは平文でDB保存 | E-02（173行目: rs("sPw") = sPw）, E-02（291行目: sPw=GeneratePassWord直接格納） | ○ |
| C-18 | ランダムパスワード生成機能あり | E-01（43行目: GeneratePassWord）, E-02（289行目: GeneratePassWord()） | ○ |
| C-19 | 会員ステータスはセレクトで選択 | E-01（42行目: cslist.showSelected） | ○ |
| C-20 | プライベートメッセージ設定あり | E-01（42行目: bGetEmailsFromSiteラジオボタン） | ○ |
| C-21 | 登録日時・更新日時・最終ログイン表示 | E-01（45行目: dCreatedTS, dUpdatedTS, dLastLoginTS） | ○ |
| C-22 | cls_customerImessでメール内容管理 | **根拠なし（customerImess.aspの確認が必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_customerImessクラスの実装詳細
  - 候補：asp/includes/customerImess.asp

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - パスワードが平文で保存されており、セキュリティ上の重大な懸念
- 1: 中リスク - フィールド値保存のトランザクション不完全性

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードのハッシュ化対応を検討する
- [ ] cls_customerImessのメール内容定義を確認する
- [ ] フィールド値保存のエラー時の挙動を確認する
