---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-コンタクトフィールド管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_contactFields.asp` - フィールド一覧画面のASPファイル
- E-02: `asp/bs_contactFieldEdit.asp` - フィールド編集画面のASPファイル
- E-03: `asp/includes/contactField.asp` - cls_contactFieldクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.85の定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フィールド管理はカスタムフィールド定義機能 | E-04, E-05 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetContacts | E-01（4行目）, E-02（4行目） | ○ |
| C-03 | フィールド名は必須入力 | E-03（46-49行目: isLeeg(sFieldName)） | ○ |
| C-04 | フィールドタイプは必須選択 | E-03（42-45行目: isLeeg(sType)） | ○ |
| C-05 | select時は選択肢必須 | E-03（50-53行目: sType=sb_select and isLeeg(sValues)） | ○ |
| C-06 | 必須かつプロフィールの制約 | E-03（54-57行目: bMandatory and not bProfile） | ○ |
| C-07 | 新規フィールドの順序は既存数+1 | E-03（72-74行目: count(*)+1） | ○ |
| C-08 | 新規作成時に既存会員へ空値作成 | E-03（91-104行目: tblContactへループ、AddNew） | ○ |
| C-09 | 上移動はiRang-1 | E-03（137-145行目: iRang=iRang-1） | ○ |
| C-10 | 下移動はiRang+1 | E-03（147-156行目: iRang=iRang+1） | ○ |
| C-11 | 削除時にフィールド値も削除 | E-03（162-163行目: delete from tblContactValues） | ○ |
| C-12 | 削除時に順序調整 | E-03（160-161行目: iRang-1 where iRang>現在のiRang） | ○ |
| C-13 | CSRF対策はcheckCSRF()で実装 | E-01（8, 12行目）, E-02（13, 19行目） | ○ |
| C-14 | 移動はURLパラメータで実行 | E-01（17行目: btnaction=MoveUP/MoveDOWN） | ○ |
| C-15 | 保存後は一覧へリダイレクト | E-02（16, 21行目: Response.Redirect） | ○ |
| C-16 | selectタイプは改行区切り選択肢 | E-03（170-176行目: split(sValues,vbcrlf)） | ○ |
| C-17 | ID暗号化はencrypt関数使用 | E-01（17行目）, E-02（24行目） | ○ |
| C-18 | 削除確認ダイアログ表示 | E-02（25行目: onclick="javascript:return confirm"） | ○ |
| C-19 | フィールドタイプ一覧はcls_contactFieldTypeList | E-01（14-15行目）, E-02（23行目） | ○ |
| C-20 | 検索対象・プロフィール表示フラグあり | E-03（11, 35行目: bSearchField, bProfile） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠があり、設計書との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] フィールドタイプ一覧の完全性を確認する（contactFieldTypeList.asp）
- [ ] 大量の既存会員がいる場合の新規フィールド作成のパフォーマンスを確認する
