---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：86-一括メール送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **cls_mail_messageのSMTP送信実装**：mail.aspの詳細確認
  2. **エラー時の継続処理**：On Error Resume Nextの影響範囲
  3. **大量送信時のパフォーマンス**：実際のタイムアウトと送信速度

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_contactSelectionActions.asp` - メール送信入力画面
- E-02: `asp/bs_massMailing2.asp` - メール送信処理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.86の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 一括メール送信は選択会員への一斉配信機能 | E-03, E-04 | ○ |
| C-02 | 権限チェックはbIntranetContacts | E-01（4行目） | ○ |
| C-03 | 件名は必須入力 | E-01（26-27行目: isLeeg(hSubject)） | ○ |
| C-04 | 本文は必須入力（HTMLタグ除去後） | E-01（28-29行目: isLeeg(removehtml)） | ○ |
| C-05 | タイムアウトは10000秒に延長 | E-02（6行目: server.ScriptTimeout=10000） | ○ |
| C-06 | 重複送信防止あり | E-02（24行目: if not contactDict.Exists） | ○ |
| C-07 | 差し込みフィールド置換処理あり | E-02（28-41行目: replace処理） | ○ |
| C-08 | Email差し込みあり | E-02（28-30行目: [Email]→contact.sEmail） | ○ |
| C-09 | パスワード差し込みあり | E-02（29-31行目: [sPw]→contact.sPw） | ○ |
| C-10 | カスタムフィールド差し込みあり | E-02（32-41行目: contactFields(field)ループ） | ○ |
| C-11 | CC送信機能あり | E-02（47-56行目: ccEmailsループ） | ○ |
| C-12 | CCメール形式チェック | E-02（50行目: CheckEmailSyntax） | ○ |
| C-13 | 履歴保存あり（tblMail） | E-02（66-69行目: mailobj.save()） | ○ |
| C-14 | 受信者保存あり（tblMailContact） | E-02（71-79行目: tblMailContactへINSERT） | ○ |
| C-15 | 完了画面へリダイレクト | E-02（80行目: Response.Redirect bs_massMailingFB.asp） | ○ |
| C-16 | 送信件数を渡す | E-02（80行目: counter=contactDict.Count） | ○ |
| C-17 | テンプレート再利用機能あり | E-01（9-16行目: resendMailID処理） | ○ |
| C-18 | 本文背景色設定可能 | E-01（5行目, 35行目: sBodyBGColor） | ○ |
| C-19 | HTMLメール対応（FCKeditor） | E-01（39行目: createFCKInstance） | ○ |
| C-20 | SMTPサーバー設定詳細 | **根拠なし（mail.aspの詳細確認が必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_mail_messageのSMTP送信実装詳細
  - 候補：asp/includes/mail.asp

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 大量送信時のタイムアウトとメールサーバー負荷
- 1: 中リスク - On Error Resume Nextによるエラー発生時の挙動

## 6) レビュアーチェックリスト（最小）
- [ ] mail.aspのcls_mail_messageクラスのSMTP設定を確認する
- [ ] 大量会員への送信テストを実施する
- [ ] エラー発生時のErrorReportの記録先を確認する
