---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-メール送信履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_mailHistory.asp` - メール送信履歴画面のASPファイル
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.87の定義）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メール送信履歴は送信メールの確認・管理機能 | E-01, E-02 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetMail | E-01（4行目: logon.hasaccess secondAdmin.bIntranetMail） | ○ |
| C-03 | 削除リクエスト時にCSRF検証 | E-01（7行目: checkCSRF()） | ○ |
| C-04 | 削除処理はtheMail.delete() | E-01（8行目: theMail.delete()） | ○ |
| C-05 | 履歴一覧はcustomer.mailsで取得 | E-01（11行目: set mails=customer.mails） | ○ |
| C-06 | 一覧に件名を表示 | E-01（12行目: mails(mail).sSubject） | ○ |
| C-07 | 一覧に送信日を表示 | E-01（12行目: convertEuroDate(mails(mail).dDateSent)） | ○ |
| C-08 | 一覧に受信者数を表示 | E-01（12行目: mails(mail).iNumberRec） | ○ |
| C-09 | 詳細はポップアップで表示 | E-01（12行目: openPopUpWindow('mailRead','bs_mailDetail.asp')） | ○ |
| C-10 | 受信者リストはポップアップで表示 | E-01（12行目: openPopUpWindow('mailReceivers','bs_mailReceivers.asp')） | ○ |
| C-11 | 削除確認ダイアログ表示 | E-01（12行目: confirm('areyousure')） | ○ |
| C-12 | 削除アイコンはdustbin.gif | E-01（12行目: dustbin.gif） | ○ |
| C-13 | テーブルはsortableクラス | E-01（12行目: class="sortable"） | ○ |
| C-14 | ID暗号化はencrypt関数使用 | E-01（12行目: encrypt(mail)） | ○ |
| C-15 | 履歴なし時はメッセージ表示 | E-01（13行目: nomessagessent） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠があり、設計書との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] bs_mailDetail.aspの詳細表示内容を確認する
- [ ] bs_mailReceivers.aspの受信者リスト表示を確認する
- [ ] 大量の履歴がある場合のパフォーマンスを確認する
