---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-アクティベーション管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_tickets.asp` - アクティベーション管理画面のASPファイル
- E-02: `asp/includes/ticket.asp` - cls_ticketクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.88の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクティベーション管理は会員登録待ち管理機能 | E-01, E-03 | ○ |
| C-02 | 権限チェックはsecondAdmin.bIntranetContacts | E-01（4行目: logon.hasaccess secondAdmin.bIntranetContacts） | ○ |
| C-03 | 削除処理はpageAction="remove" | E-01（4行目: if pageAction="remove"） | ○ |
| C-04 | 削除時にCSRF検証 | E-01（5行目: checkCSRF()） | ○ |
| C-05 | 複数チケットの一括削除が可能 | E-01（7-12行目: for each iTicketID in Request.Form） | ○ |
| C-06 | 再送信処理はpageAction="resend" | E-01（14行目: if pageAction="resend"） | ○ |
| C-07 | 再送信時にCSRF検証 | E-01（15行目: checkCSRF()） | ○ |
| C-08 | 再送信はsendTicket()で実行 | E-01（18行目: resendTicket.sendTicket()）, E-02（107-115行目） | ○ |
| C-09 | 再送信後にリダイレクト | E-01（20行目: Response.Redirect bs_tickets.asp?fbMessage=） | ○ |
| C-10 | 一覧はcustomer.ticketsで取得 | E-01（22行目: set tickets=customer.tickets） | ○ |
| C-11 | 登録日時を表示 | E-01（24行目: tickets(ticketKey).dCreatedTS） | ○ |
| C-12 | メールアドレスを表示 | E-01（24行目: clickEmail(tickets(ticketKey).sEmail)） | ○ |
| C-13 | 訪問者情報を35文字で折り返し | E-01（24行目: splitby(sVisitorDetails,35)） | ○ |
| C-14 | 削除チェックボックスあり | E-01（24行目: input type=checkbox name=iTicketID） | ○ |
| C-15 | 再送信リンクあり | E-01（24行目: pageAction=resend&amp;iTicketID=） | ○ |
| C-16 | 削除・再送信時に確認ダイアログ | E-01（24行目: confirm('areyousure')） | ○ |
| C-17 | アクティベーションリンク形式 | E-02（116-118行目: sQSUrl + "/default.asp?pageAction=profile&ac=" + sticket） | ○ |
| C-18 | テーブルはsortableクラス | E-01（23行目: class="sortable"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠があり、設計書との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] sVisitorDetailsに記録される訪問者情報の内容を確認する
- [ ] アクティベーションリンクの有効期限の有無を確認する
- [ ] 大量の未認証チケットがある場合のパフォーマンスを確認する
