---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-ページ作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_setupPage.asp` - ページタイプ選択画面（14行）
- E-02: `asp/bs_editItem.asp` - コンテンツページ編集画面（17行）
- E-03: `asp/bs_processPage.asp` - ページ保存処理（83行）
- E-04: `asp/includes/page.asp` - cls_pageクラス（600行以上）
- E-05: `asp/bs_process.asp` - 処理分岐ロジック（214行）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bPagesAdd権限チェック（新規作成） | E-01（4行目） | ○ |
| C-02 | ページタイプ選択機能 | E-01（9-12行目: fixedTypeListループ） | ○ |
| C-03 | コンテンツページ編集画面（bs_editItem.asp） | E-02 | ○ |
| C-04 | WYSIWYGエディタ（FCKEditor）使用 | E-02（13行目: createFCKInstance） | ○ |
| C-05 | CSRF検証を実行 | E-03（13行目: checkCSRF） | ○ |
| C-06 | getRequestValuesでフォーム値取得 | E-03（14行目: page.getRequestValues()） | ○ |
| C-07 | page.save()でDB保存 | E-03（15行目） | ○ |
| C-08 | タイトル必須チェック | E-04（343-346行目: isLeeg(sTitle)） | ○ |
| C-09 | コンテンツ必須チェック | E-04（352-362行目） | ○ |
| C-10 | sCode一意性チェック | E-04（364-371行目: SELECT iId where sCode=） | ○ |
| C-11 | sUserFriendlyURL一意性チェック | E-04（402-407行目） | ○ |
| C-12 | sUserFriendlyURL英数字チェック | E-04（401行目: IsAlphaNumeric） | ○ |
| C-13 | カタログ・フォーム排他チェック | E-04（419-422行目: err_catorform） | ○ |
| C-14 | ホームページ設定時にbOnline=true | E-04（434-437行目） | ○ |
| C-15 | パスワード継承（親から） | E-04（438-440行目: parentPage.sPw） | ○ |
| C-16 | パスワード継承（サイト全体から） | E-04（441-443行目: customer.sTotalPW） | ○ |
| C-17 | イントラネット継承 | E-04（444-446行目: parentPage.bIntranet） | ○ |
| C-18 | 新規作成時にAddNew | E-04（467-473行目） | ○ |
| C-19 | 既存更新時にUpdate | E-04（475-480行目, 572行目: rs.Update） | ○ |
| C-20 | ホームページフラグの排他処理 | E-04（576-585行目: update bHomepage=false） | ○ |
| C-21 | オフライン時に子ページも連動 | E-04（586-588行目: getAllSubPagesOffline） | ○ |
| C-22 | メニューキャッシュクリア | E-04（596行目: clearMenuCache） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ページ作成・編集処理が全てソースコードで確認済み
- 0: 低リスク - バリデーションロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] タイトル・コンテンツの必須チェックが正しく動作するか確認
- [ ] sCodeとsUserFriendlyURLの一意性チェックが正しく動作するか確認
- [ ] ホームページ設定時の排他処理が正しく動作するか確認
- [ ] パスワードとイントラネットの継承が正しく動作するか確認
- [ ] オフライン設定時の子ページ連動が正しく動作するか確認
