---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-テーマ/フォーラム作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_themeEdit.asp` - テーマ編集画面のASPファイル
- E-02: `asp/includes/theme.asp` - cls_themeクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.90の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーマ/フォーラム作成・編集は掲示板設定機能 | E-01, E-03 | ○ |
| C-02 | 権限チェックはsecondAdmin.bTheme | E-01（4行目: logon.hasaccess secondAdmin.bTheme） | ○ |
| C-03 | 保存処理はbtnaction=save | E-01（12行目: case l("save")） | ○ |
| C-04 | 保存時にCSRF検証 | E-01（13行目: checkCSRF()） | ○ |
| C-05 | 保存処理はtheme.save | E-01（15行目: if theme.save then） | ○ |
| C-06 | 削除処理はbtnaction=delete | E-01（18行目: case l("delete")） | ○ |
| C-07 | 削除時にCSRF検証 | E-01（19行目: checkCSRF()） | ○ |
| C-08 | 削除処理はtheme.remove | E-01（20行目: theme.remove） | ○ |
| C-09 | 削除後に一覧へリダイレクト | E-01（21行目: Response.Redirect bs_themesList.asp） | ○ |
| C-10 | 削除確認ダイアログ表示 | E-01（37行目: confirm('areyousure')） | ○ |
| C-11 | 名前は必須入力 | E-02（101-104行目: isLeeg(sName) → err_mandatory） | ○ |
| C-12 | 通知本文は必須入力 | E-02（105-108行目: isLeeg(sBodyNotification) → err_mandatory） | ○ |
| C-13 | 通知件名は必須入力 | E-02（109-112行目: isLeeg(sSubjectNotification) → err_mandatory） | ○ |
| C-14 | 匿名時ラベル必須 | E-02（113-118行目: bAllowAP and isLeeg(sLabelYourName)） | ○ |
| C-15 | ブログ時ブロガー必須 | E-02（119-124行目: iType=QS_theme_pb and isLeeg(iContactID)） | ○ |
| C-16 | コード重複チェック | E-02（125-133行目: count(iId) from tblTheme where sCode=） | ○ |
| C-17 | 購読レベル変更時にサブスクリプション整理 | E-02（186-208行目: delete from tblThemeTopicSubscription/tblThemeSubscription） | ○ |
| C-18 | コメント不許可時に返信削除 | E-02（209-213行目: not bAllowComments → delete from tblPost where iPostID is not null） | ○ |
| C-19 | 保存後にRSSキャッシュクリア | E-02（215行目: clearRSScache） | ○ |
| C-20 | 保存後にテーマキャッシュ更新 | E-02（217行目: customer.cacheThemes()） | ○ |
| C-21 | 削除時に投稿も削除 | E-02（266-271行目: cPosts(postKey).remove） | ○ |
| C-22 | 削除時にページのテーマID解除 | E-02（273行目: update tblPage set iThemeID=null） | ○ |
| C-23 | 削除時に購読削除 | E-02（275行目: delete from tblThemeSubscription） | ○ |
| C-24 | 使用箇所検索はcls_fullSearch | E-01（40-47行目: fsearch.pattern, fsearch.search()） | ○ |
| C-25 | FCKeditorで通知本文編集 | E-01（37行目: createFCKInstance...sTopicBodyNotification, sBodyNotification） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠があり、設計書との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テーマ種別定数（QS_theme_cd, QS_theme_pb, QS_theme_ts）の定義箇所を確認する
- [ ] 購読レベル定数（QS_theme_sublevel_*）の定義箇所を確認する
- [ ] cls_fullSearchの検索パフォーマンスを確認する
- [ ] 大量の投稿があるテーマの削除時間を確認する
