---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：91-アクセス統計表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **250ページ制限**：cls_searchの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_stats.asp` - 統計表示メインファイル
- E-02: `asp/includes/search.asp` - cls_searchクラス定義
- E-03: `asp/bs_security.asp` - セキュリティチェック（インクルード参照）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンのbStats権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bStats` | ○ |
| C-02 | ヒット数降順でソート | E-01 7行目 `stats.orderby="iHits desc"` | ○ |
| C-03 | パスワード保護ページを含む | E-01 10行目 `stats.includePasswordProtected=true` | ○ |
| C-04 | イントラネットページを含む | E-01 11行目 `stats.includeIntranet=true` | ○ |
| C-05 | 日次平均の計算ロジック | E-01 16行目 `round(convertGetal(stats(item).iHits/aantalDagen))` | ○ |
| C-06 | RSSヒット数をオレンジ色で表示 | E-01 17行目 `font color='#ffa500'` | ○ |
| C-07 | 統計リセット日時の表示 | E-01 17行目 `formatTimeStamp(customer.dResetStats)` | ○ |
| C-08 | 参照元サイトリンク条件 | E-01 17行目 `if customer.bScanreferer then` | ○ |
| C-09 | cls_searchクラスによるデータ取得 | E-02 全体 | ○ |
| C-10 | 機能カテゴリが「管理画面/統計」 | E-04 92行目 | ○ |
| C-11 | 関連画面No.95が統計画面 | E-05 131-132行目 | ○ |
| C-12 | 関連画面No.6がダッシュボード | E-05 13-14行目 | ○ |
| C-13 | tblPageからデータ取得 | E-02 82行目 `select * from tblPage` | ○ |
| C-14 | tblCustomerから設定取得 | E-01 13-14行目 `customer.aantalDagen` | ○ |
| C-15 | sortableテーブル使用 | E-01 14行目 `class=sortable` | ○ |
| C-16 | 出力時のサニタイズ | E-01 quotRep関数使用 | ○ |
| C-17 | 1秒以内のレスポンス要件 | **根拠なし** | △ |
| C-18 | 250ページ以下の制限 | E-02 96行目に類似実装あり、ただし統計用途での制限は未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値（レスポンス時間等）の根拠がソースコードに存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / 運用マニュアル
- 250ページ制限は検索結果の制限として存在するが、統計表示での制限は明示的に確認できない

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェック・データ取得ロジック（根拠十分）
- 0: 計算ロジック（ソースコードで確認済み）
- 1: パフォーマンス要件（数値の根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] bStats権限チェックが正しく機能することを確認
- [ ] 日次平均計算で0除算エラーが発生しないことを確認
- [ ] RSSヒット数の表示条件が正しいことを確認
- [ ] 大量ページ時のパフォーマンスを検証
