---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：92-参照元サイト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **getReferersArr関数の実装**：関数の詳細実装ファイルが未特定
  2. **filterURL/filterQuery関数**：ヘルパー関数の実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_referers.asp` - リファラー一覧メインファイル
- E-02: `asp/bs_stats.asp` - 統計画面（関連参照）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bStats権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bStats` | ○ |
| C-02 | bScanreferer設定チェック | E-01 24行目 `if not customer.bScanreferer then Response.Redirect` | ○ |
| C-03 | デフォルト期間が7日前から | E-01 29行目 `dFrom=convertEuroDate(dateAdd("d",-7,date()))` | ○ |
| C-04 | URLDecode2関数の独自実装 | E-01 4-23行目 関数定義 | ○ |
| C-05 | CSRFチェック実装 | E-01 34行目 `checkCSRF()` | ○ |
| C-06 | removeReferers関数呼び出し | E-01 35行目 `removeReferers()` | ○ |
| C-07 | getReferersArr関数でデータ取得 | E-01 38行目 `arrRef=getReferersArr(dFrom,dUntill,total)` | ○ |
| C-08 | グループ化条件がsb_ref定数で定義 | E-01 32行目, 42-56行目 | ○ |
| C-09 | Dictionary形式で集計 | E-01 40行目 `set refDict=server.CreateObject("scripting.dictionary")` | ○ |
| C-10 | 言語表示は先頭5文字 | E-01 68行目 `left(arrRef(keyValue,ref),5)` | ○ |
| C-11 | 検索クエリのURLデコード | E-01 70行目 `URLDecode2(filterQuery(arrRef(0,ref)))` | ○ |
| C-12 | sortableテーブル使用 | E-01 43行目 `class=sortable` | ○ |
| C-13 | JQDatePickerによる日付入力 | E-01 33行目 `JQDatePicker("dFrom")` | ○ |
| C-14 | リセット確認ダイアログ | E-01 83行目 `confirm('<%=l("areyousure")%>')` | ○ |
| C-15 | 機能カテゴリが「管理画面/統計」 | E-03 93行目 | ○ |
| C-16 | 関連画面No.96 | E-04 133行目 | ○ |
| C-17 | bs_stats.aspからのリンク | E-02 17行目 `bs_referers.asp` | ○ |
| C-18 | 配列インデックス0-5の構造 | E-01 59-70行目の参照パターン | ○ |
| C-19 | getReferersArr関数の詳細実装 | **根拠なし** - 関数定義ファイル未特定 | △ |
| C-20 | filterURL/filterQuery関数の実装 | **根拠なし** - 関数定義ファイル未特定 | △ |

## 4) 不足情報（Unknown / Missing）
- getReferersArr関数、filterURL関数、filterQuery関数の実装ファイルが特定されていない
  - 候補：includes/referer.asp / includes/functions.asp / begin.asp
- tblRefererテーブルのスキーマ定義
  - 候補：データベース設計書 / SQLスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェック・CSRF対策（根拠十分）
- 0: グループ化ロジック（ソースコードで確認済み）
- 1: データ取得関数の実装詳細（関数定義未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] bScanreferer設定のデフォルト値を確認
- [ ] getReferersArr関数のSQL実装を確認
- [ ] 大量データ時のパフォーマンスを検証
- [ ] URLDecode2のエラーハンドリングが適切か確認
- [ ] リセット処理のトランザクション整合性を確認
