---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 12
  claims_without_evidence: 4
confidence_derived: 0.75
---

# 根拠レポート：93-統計リセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.75**
  - 根拠あり：12 / 16、根拠なし：4
- 優先レビュー（高）
  1. **実際のリセット処理実装**：bs_process.aspまたはcustomer.aspでの実装確認が必要
  2. **tblPageのUPDATE処理**：統計カラムリセットのSQL確認が必要
  3. **トランザクション管理**：複数テーブル更新時の整合性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_stats.asp` - 統計表示・リセットリンク
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bStats権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bStats` | ○ |
| C-02 | btnaction=ResetStatsでリセット実行 | E-01 17行目 `btnaction=ResetStats` | ○ |
| C-03 | CSRFトークン付きURL | E-01 17行目 `QS_secCodeURL` | ○ |
| C-04 | confirm()による確認 | E-01 17行目 `confirm('<%=l("areyousure")%>')` | ○ |
| C-05 | リセット日時の表示 | E-01 17行目 `formatTimeStamp(customer.dResetStats)` | ○ |
| C-06 | 機能カテゴリが「管理画面/統計」 | E-02 94行目 | ○ |
| C-07 | 関連画面No.95 | E-03 132行目 | ○ |
| C-08 | bs_stats.asp内のResetStatsアクション | E-02 94行目「bs_stats.asp内のResetStatsアクション」 | ○ |
| C-09 | aantalDagen（日数）との連動 | E-01 13行目 `customer.aantalDagen` | ○ |
| C-10 | dResetStatsフィールドの存在 | E-01 17行目 `customer.dResetStats` | ○ |
| C-11 | リセットリンクがa要素で実装 | E-01 17行目 `<a onclick=...>` | ○ |
| C-12 | 多言語対応（l関数使用） | E-01 17行目 `l("reset")`, `l("areyousure")` | ○ |
| C-13 | tblCustomer.dResetStatsへのUPDATE | **根拠なし** - 実装コード未確認 | △ |
| C-14 | tblPage.iHits, iVisitorsのリセット | **根拠なし** - 実装コード未確認 | △ |
| C-15 | customer.resetStats()メソッドの存在 | **根拠なし** - customer.asp未確認 | △ |
| C-16 | トランザクション管理の実装 | **根拠なし** - 実装コード未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- リセット処理の実装コード（bs_process.aspまたはcustomer.asp）が確認されていない
  - 候補：asp/bs_process.asp / asp/includes/customer.asp
- tblPageテーブルの統計カラムリセットSQL
  - 候補：bs_process.asp内のSELECT CASE文
- トランザクション管理の方式
  - 候補：ADOのBeginTrans/CommitTrans/Rollback

## 5) リスクフラグ（レビュー観点）
- 1: リセット処理の実装詳細（コード未確認）
- 1: 複数テーブル更新のトランザクション整合性
- 0: 権限チェック・CSRF対策（根拠十分）

## 6) レビュアーチェックリスト（最小）
- [ ] bs_process.aspでResetStatsアクションの処理を確認
- [ ] customer.resetStats()メソッドの実装を確認
- [ ] tblPageの統計カラムが正しくリセットされることを確認
- [ ] 大量ページ時のリセット処理パフォーマンスを検証
- [ ] リセット後にaantalDagenが正しく再計算されることを確認
